/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

public enum GameSide {
    CLIENT("client", "/%s-loader/%s/%s/profile/json"),
    SERVER("server", "/%s-loader/%s/%s/server/json");

    private final String id;
    private final String launchJsonEndpoint;

    private GameSide(String id, String launchJsonEndpoint) {
        this.id = id;
        this.launchJsonEndpoint = launchJsonEndpoint;
    }

    public String id() {
        return this.id;
    }

    public String launchJsonEndpoint() {
        return this.launchJsonEndpoint;
    }

    public String stripFromVersion(String version) {
        return version.endsWith(this.id) ? version.substring(0, version.length() - (this.id.length() + 1)) : version;
    }

    public boolean versionMatches(String version) {
        for (GameSide side : GameSide.values()) {
            if (!version.endsWith(side.id)) continue;
            return side == this;
        }
        return true;
    }
}

