/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.lib.parsers.json.JsonReader;
import org.quiltmc.installer.lib.parsers.json.JsonWriter;

public final class Gsons {
    public static Object read(JsonReader reader) throws IOException {
        switch (reader.peek()) {
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                reader.beginArray();
                while (reader.hasNext()) {
                    list.add(Gsons.read(reader));
                }
                reader.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
                reader.beginObject();
                while (reader.hasNext()) {
                    String key = reader.nextName();
                    object.put(key, Gsons.read(reader));
                }
                reader.endObject();
                return object;
            }
            case STRING: {
                return reader.nextString();
            }
            case NUMBER: {
                return reader.nextDouble();
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case NULL: {
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public static void write(JsonWriter writer, @Nullable Object input) throws IOException {
        if (input instanceof Map) {
            writer.beginObject();
            for (Map.Entry entry : ((Map)input).entrySet()) {
                writer.name(entry.getKey().toString());
                Gsons.write(writer, entry.getValue());
            }
            writer.endObject();
        } else if (input instanceof List) {
            writer.beginArray();
            for (Object element : (List)input) {
                Gsons.write(writer, element);
            }
            writer.endArray();
        } else if (input instanceof Number) {
            writer.value((Number)input);
        } else if (input instanceof String) {
            writer.value((String)input);
        } else if (input instanceof Boolean) {
            writer.value((boolean)((Boolean)input));
        } else if (input == null) {
            writer.nullValue();
        } else {
            throw new IllegalArgumentException(String.format("Don't know how to convert %s to json", input));
        }
    }

    private Gsons() {
    }
}

