/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import org.quiltmc.installer.Connections;
import org.quiltmc.installer.GameSide;
import org.quiltmc.installer.Gsons;
import org.quiltmc.installer.Intermediary;
import org.quiltmc.installer.LoaderType;
import org.quiltmc.installer.OrnitheMeta;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.lib.parsers.json.JsonReader;
import org.quiltmc.installer.lib.parsers.json.JsonWriter;
import org.quiltmc.installer.util.Lists;
import org.quiltmc.installer.util.Maps;

public final class LaunchJson {
    public static CompletableFuture<String> getMmcJson(VersionManifest.Version gameVersion, OptionalInt intermediaryGen, Intermediary intermediary, LoaderType loaderType, String loaderVersion) {
        return LaunchJson.get(gameVersion).thenCombine(LaunchJson.get(GameSide.CLIENT, gameVersion, intermediaryGen, intermediary, loaderType, loaderVersion), (vanillaJson, moddedJson) -> {
            try {
                Map arguments;
                Map arguments2;
                Map vanillaMap = (Map)Gsons.read(JsonReader.json(vanillaJson));
                Map moddedMap = (Map)Gsons.read(JsonReader.json(moddedJson));
                String clientName = "com.mojang:minecraft:" + gameVersion.id() + ":client";
                Map downloads = (Map)vanillaMap.get("downloads");
                Map client = (Map)downloads.get("client");
                Map<String, Object> mainJar = Maps.of("downloads", Maps.of("artifact", client), "name", clientName);
                List vanillaLibraries = (List)vanillaMap.get("libraries");
                vanillaLibraries.removeIf(lib -> ((String)lib.get("name")).contains("org.lwjgl"));
                ArrayList<String> traits = new ArrayList<String>();
                if (((String)vanillaMap.get("mainClass")).contains("launchwrapper")) {
                    traits.add("texturepacks");
                }
                String minecraftArguments = vanillaMap.getOrDefault("minecraftArguments", "");
                if (vanillaMap.containsKey("arguments") && !(arguments2 = (Map)vanillaMap.get("arguments")).isEmpty()) {
                    List gameArguments = (List)arguments2.get("game");
                    if (!arguments2.isEmpty()) {
                        String combinedCombination = "";
                        for (Object gameArgument : gameArguments) {
                            if (!(gameArgument instanceof String)) continue;
                            combinedCombination = combinedCombination + gameArgument + " ";
                        }
                        minecraftArguments = combinedCombination.trim();
                        traits.add("FirstThreadOnMacOS");
                    }
                }
                List jvmArguments = Collections.emptyList();
                if (moddedMap.containsKey("arguments") && (arguments = (Map)moddedMap.get("arguments")).containsKey("jvm")) {
                    jvmArguments = (List)arguments.get("jvm");
                }
                StringWriter writer = new StringWriter();
                Gsons.write(JsonWriter.json(writer), LaunchJson.buildPackJsonMap(vanillaMap, vanillaLibraries, minecraftArguments, traits, jvmArguments, mainJar, gameVersion.id()));
                return writer.toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Map<String, Object> buildPackJsonMap(Map<String, Object> vanilaMap, List<Map<String, String>> modifiedLibraries, String minecraftArguments, List<String> traits, List<Object> jvmArguments, Map<String, Object> mainJar, String gameVersion) {
        LinkedHashMap<String, Object> moddedJsonMap = new LinkedHashMap<String, Object>();
        if (!traits.isEmpty()) {
            moddedJsonMap.put("+traits", traits);
        }
        if (!jvmArguments.isEmpty()) {
            moddedJsonMap.put("+jvmArgs", jvmArguments);
        }
        moddedJsonMap.put("assetIndex", vanilaMap.get("assetIndex"));
        moddedJsonMap.put("compatibleJavaMajors", Lists.of(8, 17, 21, 25));
        moddedJsonMap.put("compatibleJavaName", "java-runtime-epsilon");
        moddedJsonMap.put("formatVersion", 1);
        moddedJsonMap.put("libraries", modifiedLibraries);
        moddedJsonMap.put("mainClass", vanilaMap.get("mainClass"));
        moddedJsonMap.put("mainJar", mainJar);
        moddedJsonMap.put("minecraftArguments", minecraftArguments);
        moddedJsonMap.put("name", "Minecraft");
        moddedJsonMap.put("releaseTime", vanilaMap.get("releaseTime"));
        moddedJsonMap.put("requires", Lists.of(Maps.of("suggests", "${lwjgl_version}", "uid", "${lwjgl_uid}")));
        moddedJsonMap.put("type", vanilaMap.get("type"));
        moddedJsonMap.put("uid", "net.minecraft");
        moddedJsonMap.put("version", gameVersion);
        return moddedJsonMap;
    }

    public static CompletableFuture<String> get(VersionManifest.Version gameVersion) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Map map;
                URL url = new URL(gameVersion.url());
                URLConnection connection = Connections.openConnection(url);
                try (InputStreamReader input = new InputStreamReader(connection.getInputStream());){
                    map = (Map)Gsons.read(JsonReader.json(input));
                }
                map.put("id", String.format("%s-vanilla", gameVersion.id()));
                StringWriter writer = new StringWriter();
                Gsons.write(JsonWriter.json(writer), map);
                return writer.toString();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static CompletableFuture<String> get(GameSide side, VersionManifest.Version gameVersion, OptionalInt intermediaryGen, Intermediary intermediary, LoaderType loaderType, String loaderVersion) {
        String rawUrl = "https://meta.ornithemc.net" + OrnitheMeta.launchJsonEndpointPath(side, loaderType, loaderVersion, intermediaryGen, intermediary);
        return CompletableFuture.supplyAsync(() -> {
            String string;
            URL url = new URL(rawUrl);
            URLConnection connection = Connections.openConnection(url);
            InputStreamReader stream = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
            BufferedReader reader = new BufferedReader(stream);
            try {
                String line;
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                    builder.append('\n');
                }
                string = builder.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
            return string;
        }).thenApplyAsync(raw -> {
            Map map;
            try {
                map = (Map)Gsons.read(JsonReader.json(raw));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (map == null) {
                throw new RuntimeException("Read meta json is null?");
            }
            OrnitheMeta.Endpoint<List<Map<String, String>>> libraryUpgradesEndpoint = OrnitheMeta.libraryUpgradesEndpoint(intermediaryGen, gameVersion.id());
            OrnitheMeta meta = OrnitheMeta.create("https://meta.ornithemc.net", Collections.singleton(libraryUpgradesEndpoint)).join();
            List<Map<String, String>> libraryUpgrades = meta.getEndpoint(libraryUpgradesEndpoint);
            if (loaderType == LoaderType.QUILT) {
                switch (loaderVersion) {
                    case "0.19.2": 
                    case "0.19.4": 
                    case "0.19.3": {
                        LaunchJson.disableBeacon(map);
                    }
                }
            }
            List libraries = (List)map.get("libraries");
            libraries.addAll(libraryUpgrades);
            StringWriter writer = new StringWriter();
            try {
                Gsons.write(JsonWriter.json(writer), map);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return writer.toString();
        });
    }

    private static void disableBeacon(Map<?, ?> map) {
        Map arguments = (Map)map.get("arguments");
        arguments.computeIfAbsent("jvm", key -> new ArrayList()).add("-Dloader.disable_beacon=true");
    }

    private LaunchJson() {
    }
}

