/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;

public class Main {
    public static void main(String[] args) {
        try {
            if (GraphicsEnvironment.isHeadless() || args.length != 0) {
                MethodHandles.lookup().findStatic(Class.forName("org.quiltmc.installer.CliInstaller"), "run", MethodType.methodType(Void.TYPE, String[].class)).invokeExact(args);
            } else {
                MethodHandles.lookup().findStatic(Class.forName("org.quiltmc.installer.gui.swing.SwingInstaller"), "run", MethodType.methodType(Void.TYPE)).invokeExact();
            }
        }
        catch (UnsupportedClassVersionError error) {
            if (GraphicsEnvironment.isHeadless() || args.length != 0) {
                System.out.println("Quilt Installer requires Java 17 to run.");
                System.exit(1);
            }
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                e.printStackTrace();
            }
            Main.showPopup("Ornithe Installer crashed!", "<html>Ornithe Installer needs Java 17 to run.<br><br>Install the latest LTS release of Java from <a href=\"https://adoptium.net/\">Eclipse Adoptium</a> and try again.<br><br>If you need help, ask in the <a href=\"https://discord.gg/JbRbRf62pn\">Ornithe Discord server</a>.</html>", -1, 0);
            System.exit(1);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected static boolean showPopup(String title, String description, int optionType, int messageType) {
        JEditorPane pane = new JEditorPane("text/html", "<html><body style=\"" + Main.buildEditorPaneStyle() + "\">" + description + "</body></html>");
        pane.setEditable(false);
        pane.addHyperlinkListener(e -> {
            block3: {
                try {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block3;
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                        break block3;
                    }
                    throw new UnsupportedOperationException("Failed to open " + e.getURL().toString());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        return JOptionPane.showOptionDialog(null, pane, title, optionType, messageType, null, null, null) == 0;
    }

    private static String buildEditorPaneStyle() {
        JLabel label = new JLabel();
        Font font = label.getFont();
        Color color = label.getBackground();
        return String.format("font-family:%s;font-weight:%s;font-size:%dpt;background-color: rgb(%d,%d,%d);", font.getFamily(), font.isBold() ? "bold" : "normal", font.getSize(), color.getRed(), color.getGreen(), color.getBlue());
    }
}

