/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.quiltmc.installer.Connections;
import org.quiltmc.installer.Gsons;
import org.quiltmc.installer.Intermediary;
import org.quiltmc.installer.IntermediaryGenerations;
import org.quiltmc.installer.LWJGL;
import org.quiltmc.installer.LaunchJson;
import org.quiltmc.installer.LoaderType;
import org.quiltmc.installer.OrnitheMeta;
import org.quiltmc.installer.ParseException;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.lib.parsers.json.JsonReader;
import org.quiltmc.installer.lib.parsers.json.JsonToken;
import org.quiltmc.installer.lib.parsers.json.JsonWriter;
import org.quiltmc.installer.util.Maps;

public class MmcPackCreator {
    private static final String ENV_WRAPPER_COMMAND = "WrapperCommand=env __GL_THREADED_OPTIMIZATIONS=0";
    private static final boolean IS_LINUX_LIKE_OS;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LWJGL findLwjgl(VersionManifest manifest, String gameVersion) {
        VersionManifest.Version version = manifest.getVersion(gameVersion);
        try {
            URL url = new URL(version.url());
            URLConnection connection = Connections.openConnection(url);
            try (JsonReader reader = JsonReader.json(new BufferedReader(new InputStreamReader(connection.getInputStream())));){
                LWJGL lwjgl = MmcPackCreator.findLwjgl(reader);
                if (lwjgl == null) throw new RuntimeException("unable to find lwjgl version for Minecraft " + gameVersion);
                LWJGL lWJGL = lwjgl;
                return lWJGL;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("issue while finding lwjgl version for Minecraft " + gameVersion, e);
        }
    }

    private static LWJGL findLwjgl(JsonReader reader) throws IOException, ParseException {
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            throw new ParseException("Version Manifest was invalid type", reader);
        }
        reader.beginObject();
        block26: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "libraries": {
                    if (reader.peek() != JsonToken.BEGIN_ARRAY) {
                        throw new ParseException("libraries must be an array", reader);
                    }
                    reader.beginArray();
                    while (reader.hasNext()) {
                        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                            throw new ParseException("library entries must all be objects", reader);
                        }
                        reader.beginObject();
                        String lwjglVersion = null;
                        String lwjglUrl = null;
                        block28: while (reader.hasNext()) {
                            switch (reader.nextName()) {
                                case "name": {
                                    if (reader.peek() != JsonToken.STRING) {
                                        throw new ParseException("library name must be a string", reader);
                                    }
                                    String name = reader.nextString();
                                    String[] maven = name.split("[:]");
                                    String artifact = maven[1];
                                    String version = maven[2];
                                    if (!artifact.equals("lwjgl")) continue block28;
                                    lwjglVersion = version;
                                    continue block28;
                                }
                                case "downloads": {
                                    if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                                        reader.skipValue();
                                        continue block28;
                                    }
                                    reader.beginObject();
                                    block29: while (reader.hasNext()) {
                                        switch (reader.nextName()) {
                                            case "artifact": {
                                                if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                                                    reader.skipValue();
                                                    continue block29;
                                                }
                                                reader.beginObject();
                                                block30: while (reader.hasNext()) {
                                                    switch (reader.nextName()) {
                                                        case "url": {
                                                            if (reader.peek() != JsonToken.STRING) {
                                                                throw new ParseException("download artifact url must be a string", reader);
                                                            }
                                                            String url = reader.nextString();
                                                            if (!url.contains("lwjgl")) continue block30;
                                                            lwjglUrl = url;
                                                            continue block30;
                                                        }
                                                    }
                                                    reader.skipValue();
                                                }
                                                reader.endObject();
                                                continue block29;
                                            }
                                        }
                                        reader.skipValue();
                                    }
                                    reader.endObject();
                                    continue block28;
                                }
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                        if (lwjglVersion == null || lwjglUrl == null) continue;
                        return new LWJGL(lwjglVersion, lwjglUrl);
                    }
                    reader.endArray();
                    continue block26;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return null;
    }

    private static String transformPackJson(String examplePackJson, String gameVersion, LoaderType type, String loaderVersion, LWJGL lwjgl, String intermediaryVersion) {
        return examplePackJson.replaceAll("\\$\\{mc_version}", gameVersion).replaceAll("\\$\\{intermediary_ver}", intermediaryVersion).replaceAll("\\$\\{loader_version}", loaderVersion).replaceAll("\\$\\{loader_name}", type.getLocalizedName() + " Loader").replaceAll("\\$\\{loader_uid}", type.getMavenUid()).replaceAll("\\$\\{lwjgl_version}", lwjgl.getVersion()).replaceAll("\\$\\{lwjgl_major_ver}", lwjgl.getMajorVersion()).replaceAll("\\$\\{lwjgl_uid}", lwjgl.getUid());
    }

    private static String transformMinecraftJson(String minecraftPatchString, LWJGL lwjgl) {
        return minecraftPatchString.replaceAll("\\$\\{lwjgl_version}", lwjgl.getVersion()).replaceAll("\\$\\{lwjgl_uid}", lwjgl.getUid());
    }

    private static String addLibraryUpgrades(Path instanceZipRoot, String gameVersion, LoaderType loaderType, String loaderVersion, OptionalInt intermediaryGen, Intermediary intermediary, String packJson) throws IOException {
        String patch = "{\"formatVersion\": 1, \"libraries\": [{\"name\": \"%s\",\"url\": \"%s\"}],\"name\": \"%s\",\"type\": \"release\",\"uid\": \"%s\",\"version\": \"%s\"}";
        OrnitheMeta.Endpoint<List<Map<String, String>>> librariesEndpoint = OrnitheMeta.libraryUpgradesEndpoint(intermediaryGen, gameVersion);
        OrnitheMeta meta = OrnitheMeta.create("https://meta.ornithemc.net", Collections.singleton(librariesEndpoint)).join();
        List<Map<String, String>> libraries = meta.getEndpoint(librariesEndpoint);
        Map pack = (Map)Gsons.read(JsonReader.json(packJson));
        List components = (List)pack.get("components");
        for (Map<String, String> map : libraries) {
            String name = map.get("name");
            String url = map.get("url");
            String uid = name.substring(0, name.lastIndexOf(58)).replace(":", ".");
            String libName = name.substring(name.indexOf(58) + 1, name.lastIndexOf(58));
            String version = name.substring(name.lastIndexOf(58) + 1);
            Files.write(instanceZipRoot.resolve("patches").resolve(uid + ".json"), String.format(patch, name, url, libName, uid, version).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            components.add(Maps.of("cachedName", libName, "cachedVersion", version, "uid", uid));
        }
        StringWriter writer = new StringWriter();
        Gsons.write(JsonWriter.json(writer), pack);
        return writer.toString();
    }

    public static void compileMmcZip(Path outPutDir, String gameVersion, LoaderType loaderType, String loaderVersion, OptionalInt intermediaryGen, Intermediary intermediary, VersionManifest manifest, boolean copyProfilePath) {
        String examplePackDir = "/packformat";
        String packJsonPath = "mmc-pack.json";
        String intermediaryJsonPath = "patches/net.fabricmc.intermediary.json";
        String lwjglJsonPath = "patches/org.lwjgl.json";
        String instanceCfgPath = "instance.cfg";
        String iconPath = "ornithe.png";
        String minecraftPatchPath = "patches/net.minecraft.json";
        VersionManifest.Version version = manifest.getVersion(gameVersion);
        String intermediaryMavenNotation = intermediary.getMavenNotation();
        String intermediaryArtifact = intermediaryMavenNotation.substring(0, intermediaryMavenNotation.lastIndexOf(58));
        String intermediaryVersion = intermediary.getVersion();
        try {
            LWJGL lwjgl = MmcPackCreator.findLwjgl(manifest, gameVersion);
            String transformedPackJson = MmcPackCreator.transformPackJson(MmcPackCreator.readResource(examplePackDir, packJsonPath), gameVersion, loaderType, loaderVersion, lwjgl, intermediaryVersion);
            String transformedIntermediaryJson = MmcPackCreator.readResource(examplePackDir, intermediaryJsonPath).replaceAll("\\$\\{mc_version}", gameVersion).replaceAll("\\$\\{intermediary_ver}", intermediaryVersion).replaceAll("\\$\\{intermediary_maven}", intermediaryArtifact);
            String transformedLwjglJson = MmcPackCreator.readResource(examplePackDir, lwjglJsonPath).replaceAll("\\$\\{lwjgl_version}", lwjgl.getVersion()).replaceAll("\\$\\{lwjgl_major_ver}", lwjgl.getMajorVersion()).replaceAll("\\$\\{lwjgl_uid}", lwjgl.getUid());
            String transformedInstanceCfg = MmcPackCreator.readResource(examplePackDir, instanceCfgPath).replaceAll("\\$\\{intermediary_generation}", String.valueOf(intermediaryGen.orElseGet(IntermediaryGenerations::stable))).replaceAll("\\$\\{loader_type}", loaderType.getLocalizedName()).replaceAll("\\$\\{mc_version}", gameVersion);
            String transformedMinecraftJson = MmcPackCreator.transformMinecraftJson(LaunchJson.getMmcJson(version, intermediaryGen, intermediary, loaderType, loaderVersion).join(), lwjgl);
            if (IS_LINUX_LIKE_OS) {
                transformedInstanceCfg = transformedInstanceCfg + "\nOverrideCommands=true\nWrapperCommand=env __GL_THREADED_OPTIMIZATIONS=0";
            }
            Path zipFile = outPutDir.resolve("Ornithe Gen" + intermediaryGen.orElseGet(IntermediaryGenerations::stable) + " " + loaderType.getLocalizedName() + " " + gameVersion + ".zip");
            Files.deleteIfExists(zipFile);
            ZipOutputStream dummyZipOutputStream = new ZipOutputStream(Files.newOutputStream(zipFile.toFile().toPath(), new OpenOption[0]));
            dummyZipOutputStream.putNextEntry(new ZipEntry("mmc-pack.json"));
            dummyZipOutputStream.write("if you see this, this didn't work".getBytes(StandardCharsets.UTF_8));
            dummyZipOutputStream.closeEntry();
            dummyZipOutputStream.close();
            try (FileSystem fs = FileSystems.newFileSystem(zipFile, (ClassLoader)null);){
                Files.copy(MmcPackCreator.class.getResourceAsStream(examplePackDir + "/" + iconPath), fs.getPath(iconPath, new String[0]), new CopyOption[0]);
                Files.write(fs.getPath(instanceCfgPath, new String[0]), transformedInstanceCfg.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                Files.createDirectory(fs.getPath("patches", new String[0]), new FileAttribute[0]);
                Files.write(fs.getPath(intermediaryJsonPath, new String[0]), transformedIntermediaryJson.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                if (lwjgl.isCustom()) {
                    Files.write(fs.getPath(lwjglJsonPath, new String[0]), transformedLwjglJson.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                Files.write(fs.getPath(minecraftPatchPath, new String[0]), transformedMinecraftJson.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                String packJsonWithLibraries = MmcPackCreator.addLibraryUpgrades(fs.getPath("/", new String[0]), gameVersion, loaderType, loaderVersion, intermediaryGen, intermediary, transformedPackJson);
                Files.write(fs.getPath(packJsonPath, new String[0]), packJsonWithLibraries.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            if (copyProfilePath) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(zipFile.toString()), null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String readResource(String dir, String path) throws IOException {
        int length;
        InputStream resource = MmcPackCreator.class.getResourceAsStream(String.format("%s/%s", dir, path));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = resource.read(buffer)) != -1) {
            os.write(buffer, 0, length);
        }
        return os.toString(StandardCharsets.UTF_8.name());
    }

    static {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        IS_LINUX_LIKE_OS = os.contains("linux") || !os.contains("win") && !os.contains("mac");
    }
}

