/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.action;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.OptionalInt;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.Intermediary;
import org.quiltmc.installer.LauncherType;
import org.quiltmc.installer.LoaderType;
import org.quiltmc.installer.Localization;
import org.quiltmc.installer.action.InstallClient;
import org.quiltmc.installer.action.InstallServer;
import org.quiltmc.installer.action.ListVersions;

public abstract class Action<M> {
    public static final Action<Void> DISPLAY_HELP = new Action<Void>(){

        @Override
        public void run(Consumer<Void> statusTracker) {
            this.printHelp();
            System.exit(1);
        }

        private void printHelp() {
            String platformExecutableName = "ornithe-installer";
            InputStream usageStream = Action.class.getClassLoader().getResourceAsStream("lang/" + Locale.getDefault().toLanguageTag() + ".usage");
            if (usageStream == null && (usageStream = Action.class.getClassLoader().getResourceAsStream("lang/en-US.usage")) == null) {
                throw new RuntimeException("Could not find usage translation for English locale");
            }
            StringBuilder usage = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(usageStream));){
                String s;
                while ((s = reader.readLine()) != null) {
                    usage.append(s);
                    usage.append('\n');
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String noArgsUsage = GraphicsEnvironment.isHeadless() ? Localization.get("cli.usage.description.headless") : Localization.get("cli.usage.description");
            1.println(Localization.get("title") + " v" + "0.14.0");
            1.println("");
            1.println(new MessageFormat(usage.toString()).format(new String[]{platformExecutableName, noArgsUsage}));
        }
    };

    public static Action<Void> listVersions(LoaderType loaderType, OptionalInt intermediaryGen, boolean minecraftSnapshots, boolean loaderBetas) {
        return new ListVersions(loaderType, intermediaryGen, minecraftSnapshots, loaderBetas);
    }

    public static InstallClient installClient(String minecraftVersion, LauncherType launcherType, LoaderType loaderType, @Nullable String loaderVersion, OptionalInt intermediaryGen, @Nullable Intermediary intermediary, @Nullable String installDir, boolean generateProfile, boolean copyProfilePath) {
        return new InstallClient(minecraftVersion, launcherType, loaderType, loaderVersion, intermediaryGen, intermediary, installDir, generateProfile, copyProfilePath);
    }

    public static InstallServer installServer(String minecraftVersion, LoaderType loaderType, @Nullable String loaderVersion, OptionalInt intermediaryGen, @Nullable Intermediary intermediary, String installDir, boolean createScripts, boolean installServer) {
        return new InstallServer(minecraftVersion, loaderType, loaderVersion, intermediaryGen, intermediary, installDir, createScripts, installServer);
    }

    static void println(String message) {
        System.out.println(message);
    }

    static void eprintln(String message) {
        System.err.println(message);
    }

    public abstract void run(Consumer<M> var1);
}

