/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.action;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.GameSide;
import org.quiltmc.installer.Gsons;
import org.quiltmc.installer.Intermediary;
import org.quiltmc.installer.LaunchJson;
import org.quiltmc.installer.LauncherProfiles;
import org.quiltmc.installer.LauncherType;
import org.quiltmc.installer.LoaderType;
import org.quiltmc.installer.MmcPackCreator;
import org.quiltmc.installer.OsPaths;
import org.quiltmc.installer.action.Action;
import org.quiltmc.installer.action.InstallMessageType;
import org.quiltmc.installer.action.MinecraftInstallation;
import org.quiltmc.installer.lib.parsers.json.JsonReader;

public final class InstallClient
extends Action<InstallMessageType> {
    private final String minecraftVersion;
    private final LauncherType launcherType;
    private final LoaderType loaderType;
    @Nullable
    private final String loaderVersion;
    private final OptionalInt intermediaryGen;
    @Nullable
    private final Intermediary intermediary;
    @Nullable
    private final String installDir;
    private final boolean generateProfile;
    private final boolean copyProfilePath;
    private Path installDirPath;

    InstallClient(String minecraftVersion, LauncherType launcherType, LoaderType loaderType, @Nullable String loaderVersion, OptionalInt intermediaryGen, @Nullable Intermediary intermediary, @Nullable String installDir, boolean generateProfile, boolean copyProfilePath) {
        this.minecraftVersion = minecraftVersion;
        this.launcherType = launcherType;
        this.loaderType = loaderType;
        this.loaderVersion = loaderVersion;
        this.intermediaryGen = intermediaryGen;
        this.intermediary = intermediary;
        this.installDir = installDir;
        this.generateProfile = generateProfile;
        this.copyProfilePath = copyProfilePath;
    }

    @Override
    public void run(Consumer<InstallMessageType> statusTracker) {
        switch (this.launcherType) {
            case OFFICIAL: {
                this.installOfficial(statusTracker);
                break;
            }
            case MULTIMC: {
                this.installMultimc(statusTracker);
                break;
            }
            default: {
                throw new RuntimeException("don't know how to install into " + (Object)((Object)this.launcherType));
            }
        }
    }

    private void installOfficial(Consumer<InstallMessageType> statusTracker) {
        Path installDir = this.installDir == null ? OsPaths.getDefaultInstallationDir() : Paths.get(this.installDir, new String[0]);
        this.installDirPath = installDir;
        InstallClient.println(String.format("Installing Minecraft client at: %s", installDir));
        if (this.loaderVersion != null) {
            InstallClient.println(String.format("Installing Minecraft client of version %s with loader version %s", this.minecraftVersion, this.loaderVersion));
        } else {
            InstallClient.println(String.format("Installing Minecraft client of version %s", this.minecraftVersion));
        }
        CompletableFuture<MinecraftInstallation.InstallationInfo> installationInfoFuture = MinecraftInstallation.getInfo(GameSide.CLIENT, this.minecraftVersion, this.loaderType, this.loaderVersion, this.intermediaryGen, this.intermediary);
        ((CompletableFuture)((CompletableFuture)installationInfoFuture.thenCompose(installationInfo -> LaunchJson.get(installationInfo.manifest().getVersion(this.minecraftVersion)).thenCompose(vanillaLaunchJson -> LaunchJson.get(GameSide.CLIENT, installationInfo.manifest().getVersion(this.minecraftVersion), installationInfo.intermediaryGen(), installationInfo.intermediary(), this.loaderType, installationInfo.loaderVersion()).thenAccept(launchJson -> {
            Map launchJsonMap;
            Map vanillaLaunchJsonMap;
            InstallClient.println("Creating profile launch json");
            try {
                vanillaLaunchJsonMap = (Map)Gsons.read(JsonReader.json(vanillaLaunchJson));
                launchJsonMap = (Map)Gsons.read(JsonReader.json(launchJson));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (!vanillaLaunchJsonMap.containsKey("id")) {
                throw new RuntimeException("vanilla launcher profile json is missing the profile id!");
            }
            if (!launchJsonMap.containsKey("id")) {
                throw new RuntimeException("launcher profile json is missing the profile id!");
            }
            String vanillaProfileName = (String)vanillaLaunchJsonMap.get("id");
            String profileName = (String)launchJsonMap.get("id");
            Path versionsDir = this.installDirPath.resolve("versions");
            Path vanillaProfileDir = versionsDir.resolve(vanillaProfileName);
            Path vanillaProfileJson = vanillaProfileDir.resolve(vanillaProfileName + ".json");
            Path profileDir = versionsDir.resolve(profileName);
            Path profileJson = profileDir.resolve(profileName + ".json");
            InstallClient.clearProfileDir(vanillaProfileDir);
            InstallClient.clearProfileDir(profileDir);
            InstallClient.makePretenderJar(vanillaProfileDir, vanillaProfileName);
            InstallClient.makePretenderJar(profileDir, profileName);
            InstallClient.writeLaunchJson(vanillaProfileJson, vanillaLaunchJson);
            InstallClient.writeLaunchJson(profileJson, launchJson);
            if (this.generateProfile) {
                try {
                    InstallClient.println("Creating new profile");
                    LauncherProfiles.updateProfiles(this.installDirPath, profileName, this.minecraftVersion, this.loaderType, this.intermediaryGen);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            statusTracker.accept(InstallMessageType.SUCCEED);
            InstallClient.println("Completed installation");
        })))).exceptionally(e -> {
            InstallClient.eprintln("Failed to install client");
            e.printStackTrace();
            statusTracker.accept(InstallMessageType.FAIL);
            return null;
        })).join();
    }

    private static void clearProfileDir(Path dir) {
        try {
            Files.walk(dir, new FileVisitOption[0]).map(Path::toFile).sorted((o1, o2) -> -o1.compareTo((File)o2)).forEach(File::delete);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void makePretenderJar(Path dir, String profileName) {
        try {
            Files.createFile(dir.resolve(profileName + ".jar"), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void writeLaunchJson(Path path, String json) {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(path, StandardOpenOption.CREATE_NEW));){
            ((Writer)writer).append(json);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void installMultimc(Consumer<InstallMessageType> statusTracker) {
        CompletableFuture<MinecraftInstallation.InstallationInfo> installationInfoFuture = MinecraftInstallation.getInfo(GameSide.CLIENT, this.minecraftVersion, this.loaderType, this.loaderVersion, this.intermediaryGen, this.intermediary);
        ((CompletableFuture)((CompletableFuture)installationInfoFuture.thenAccept(installationInfo -> {
            MmcPackCreator.compileMmcZip(Paths.get(this.installDir, new String[0]), this.minecraftVersion, this.loaderType, installationInfo.loaderVersion(), installationInfo.intermediaryGen(), installationInfo.intermediary(), installationInfo.manifest(), this.copyProfilePath);
            statusTracker.accept(InstallMessageType.SUCCEED);
        })).exceptionally(e -> {
            InstallClient.eprintln("Failed to generate multimc pack");
            e.printStackTrace();
            statusTracker.accept(InstallMessageType.FAIL);
            return null;
        })).join();
    }
}

