/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.action;

import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.GameSide;
import org.quiltmc.installer.Intermediary;
import org.quiltmc.installer.LoaderType;
import org.quiltmc.installer.OrnitheMeta;
import org.quiltmc.installer.VersionManifest;

public final class MinecraftInstallation {
    public static CompletableFuture<InstallationInfo> getInfo(GameSide side, String gameVersion, LoaderType loaderType, @Nullable String loaderVersion, OptionalInt intermediaryGen, @Nullable Intermediary intermediaryVersion) {
        CompletionStage versionManifest = VersionManifest.create(intermediaryGen).thenApply(manifest -> {
            if (manifest.getVersion(gameVersion) != null) {
                return manifest;
            }
            throw new IllegalArgumentException(String.format("Minecraft version %s does not exist", gameVersion));
        });
        HashSet endpoints = new HashSet();
        endpoints.add(OrnitheMeta.loaderVersionsEndpoint(intermediaryGen, loaderType));
        endpoints.add(OrnitheMeta.intermediaryVersionsEndpoint(intermediaryGen));
        CompletableFuture<OrnitheMeta> metaFuture = OrnitheMeta.create("https://meta.ornithemc.net", endpoints);
        CompletionStage intermediary = metaFuture.thenApply(meta -> {
            if (intermediaryVersion != null) {
                return intermediaryVersion;
            }
            List<Intermediary> intermediaryVersions = meta.getEndpoint(OrnitheMeta.intermediaryVersionsEndpoint(intermediaryGen));
            for (Intermediary iv : intermediaryVersions) {
                if (!side.versionMatches(iv.getVersion()) || !gameVersion.equals(side.stripFromVersion(iv.getVersion()))) continue;
                return iv;
            }
            throw new IllegalArgumentException(String.format("Minecraft version %s exists but has no intermediary", gameVersion));
        });
        CompletionStage loaderVersionFuture = metaFuture.thenApply(meta -> {
            List<String> versions = meta.getEndpoint(OrnitheMeta.loaderVersionsEndpoint(intermediaryGen, loaderType));
            if (loaderVersion != null) {
                if (!versions.contains(loaderVersion)) {
                    throw new IllegalStateException(String.format("Specified loader version %s was not found", loaderVersion));
                }
                return versions.get(versions.indexOf(loaderVersion));
            }
            if (versions.size() == 0) {
                throw new IllegalStateException("No loader versions were found");
            }
            return versions.stream().filter(version -> !version.contains("-")).findFirst().get();
        });
        return CompletableFuture.allOf(new CompletableFuture[]{versionManifest, intermediary, loaderVersionFuture}).thenApply(arg_0 -> MinecraftInstallation.lambda$getInfo$4((CompletableFuture)loaderVersionFuture, intermediaryGen, (CompletableFuture)intermediary, (CompletableFuture)versionManifest, arg_0));
    }

    private MinecraftInstallation() {
    }

    private static /* synthetic */ InstallationInfo lambda$getInfo$4(CompletableFuture loaderVersionFuture, OptionalInt intermediaryGen, CompletableFuture intermediary, CompletableFuture versionManifest, Void _v) {
        try {
            return new InstallationInfo((String)loaderVersionFuture.get(), intermediaryGen, (Intermediary)intermediary.get(), (VersionManifest)versionManifest.get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class InstallationInfo {
        private final String loaderVersion;
        private final OptionalInt intermediaryGen;
        private final Intermediary intermediary;
        private final VersionManifest manifest;

        InstallationInfo(String loaderVersion, OptionalInt intermediaryGen, Intermediary intermediary, VersionManifest manifest) {
            this.loaderVersion = loaderVersion;
            this.intermediaryGen = intermediaryGen;
            this.intermediary = intermediary;
            this.manifest = manifest;
        }

        public String loaderVersion() {
            return this.loaderVersion;
        }

        public OptionalInt intermediaryGen() {
            return this.intermediaryGen;
        }

        public Intermediary intermediary() {
            return this.intermediary;
        }

        public VersionManifest manifest() {
            return this.manifest;
        }
    }
}

