/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.gui.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.GameSide;
import org.quiltmc.installer.Intermediary;
import org.quiltmc.installer.LauncherType;
import org.quiltmc.installer.LoaderType;
import org.quiltmc.installer.Localization;
import org.quiltmc.installer.OsPaths;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.action.Action;
import org.quiltmc.installer.action.InstallClient;
import org.quiltmc.installer.action.InstallMessageType;
import org.quiltmc.installer.gui.swing.AbstractPanel;
import org.quiltmc.installer.gui.swing.SwingInstaller;

final class ClientPanel
extends AbstractPanel
implements Consumer<InstallMessageType> {
    private final JComboBox<String> minecraftVersionSelector;
    private final JComboBox<LauncherLabel> launcherTypeSelector;
    private final JComboBox<AbstractPanel.LoaderLabel> loaderTypeSelector;
    private final JComboBox<String> loaderVersionSelector;
    private final JCheckBox showSnapshotsCheckBox;
    private final JCheckBox showLoaderBetasCheckBox;
    private final JTextField installLocation;
    private final JButton selectInstallationLocation;
    private JCheckBox generateProfileCheckBox;
    private JCheckBox copyProfilePathCheckBox;
    private final JButton installButton;
    private boolean showSnapshots;
    private boolean showLoaderBetas;
    private boolean generateProfile;
    private boolean copyProfilePath;

    ClientPanel(SwingInstaller gui) {
        super(gui);
        JComponent row1 = this.addRow();
        row1.add(new JLabel(Localization.get("gui.game.version")));
        this.minecraftVersionSelector = new JComboBox();
        row1.add(this.minecraftVersionSelector);
        this.minecraftVersionSelector.setPreferredSize(new Dimension(220, 26));
        this.minecraftVersionSelector.addItem(Localization.get("gui.install.loading"));
        this.minecraftVersionSelector.setEnabled(false);
        this.showSnapshotsCheckBox = new JCheckBox(Localization.get("gui.game.version.snapshots"));
        row1.add(this.showSnapshotsCheckBox);
        this.showSnapshotsCheckBox.setEnabled(false);
        this.showSnapshotsCheckBox.addItemListener(e -> {
            if (this.manifest() != null) {
                this.showSnapshots = e.getStateChange() == 1;
                ClientPanel.populateMinecraftVersions(GameSide.CLIENT, this.minecraftVersionSelector, this.manifest(), this.intermediaryVersions(), this.showSnapshots);
            }
        });
        JComponent rowOnePointOne = this.addRow();
        rowOnePointOne.add(new JLabel(Localization.get("gui.launcher.type")));
        this.launcherTypeSelector = new JComboBox();
        rowOnePointOne.add(this.launcherTypeSelector);
        this.launcherTypeSelector.setPreferredSize(new Dimension(200, 26));
        for (LauncherType launcherType : LauncherType.values()) {
            this.launcherTypeSelector.addItem(new LauncherLabel(launcherType));
        }
        this.launcherTypeSelector.setEnabled(true);
        JComponent row2 = this.addRow();
        row2.add(new JLabel(Localization.get("gui.loader.type")));
        this.loaderTypeSelector = new JComboBox();
        row2.add(this.loaderTypeSelector);
        this.loaderTypeSelector.setPreferredSize(new Dimension(200, 26));
        for (Enum enum_ : LoaderType.values()) {
            this.loaderTypeSelector.addItem(new AbstractPanel.LoaderLabel(this, (LoaderType)enum_));
        }
        this.loaderTypeSelector.setEnabled(true);
        JComponent row3 = this.addRow();
        row3.add(new JLabel(Localization.get("gui.loader.version")));
        this.loaderVersionSelector = new JComboBox();
        row3.add(this.loaderVersionSelector);
        this.loaderVersionSelector.setPreferredSize(new Dimension(200, 26));
        this.loaderVersionSelector.addItem(Localization.get("gui.install.loading"));
        this.loaderVersionSelector.setEnabled(false);
        this.showLoaderBetasCheckBox = new JCheckBox(Localization.get("gui.loader.version.betas"));
        row3.add(this.showLoaderBetasCheckBox);
        this.showLoaderBetasCheckBox.setEnabled(false);
        this.showLoaderBetasCheckBox.addItemListener(e -> {
            if (this.loaderVersions() != null) {
                this.showLoaderBetas = e.getStateChange() == 1;
                ClientPanel.populateLoaderVersions(GameSide.CLIENT, this.loaderVersionSelector, this.loaderVersions(this.loaderType()), this.showLoaderBetas);
            }
        });
        this.loaderTypeSelector.addItemListener(e -> {
            if (this.loaderVersions() != null) {
                ClientPanel.populateLoaderVersions(GameSide.CLIENT, this.loaderVersionSelector, this.loaderVersions(this.loaderType()), this.showLoaderBetas);
            }
        });
        JComponent row4 = this.addRow();
        row4.add(new JLabel(Localization.get("gui.install-location")));
        this.installLocation = new JTextField();
        row4.add(this.installLocation);
        this.installLocation.setPreferredSize(new Dimension(300, 26));
        this.installLocation.setText(OsPaths.getDefaultInstallationDir().toString());
        this.selectInstallationLocation = new JButton();
        row4.add(this.selectInstallationLocation);
        this.selectInstallationLocation.setText("...");
        this.selectInstallationLocation.addActionListener(e -> {
            @Nullable String newLocation = ClientPanel.displayFileChooser(this.installLocation.getText());
            if (newLocation != null) {
                this.installLocation.setText(newLocation);
            }
        });
        JComponent row5 = this.addRow();
        JCheckBox generateProfileBox = new JCheckBox(Localization.get("gui.client.generate-profile"), null, true);
        row5.add(generateProfileBox);
        generateProfileBox.addItemListener(e -> {
            this.generateProfile = e.getStateChange() == 1;
        });
        this.generateProfile = true;
        this.generateProfileCheckBox = generateProfileBox;
        this.copyProfilePathCheckBox = new JCheckBox(Localization.get("gui.client.copy-profile-to-clipboard"), null, true);
        row5.add(this.copyProfilePathCheckBox).setVisible(false);
        this.copyProfilePathCheckBox.addItemListener(e -> {
            this.copyProfilePath = e.getStateChange() == 1;
        });
        this.copyProfilePath = true;
        JComponent row6 = this.addRow();
        this.installButton = new JButton();
        row6.add(this.installButton);
        this.installButton.setEnabled(false);
        this.installButton.setText(Localization.get("gui.install.loading"));
        this.installButton.addActionListener(this::install);
        this.launcherTypeSelector.addItemListener(item -> {
            switch (this.launcherType()) {
                case OFFICIAL: {
                    this.generateProfileCheckBox.setVisible(true);
                    this.copyProfilePathCheckBox.setVisible(false);
                    this.installLocation.setText(OsPaths.getDefaultInstallationDir().toString());
                    this.installButton.setText(Localization.get("gui.install"));
                    break;
                }
                case MULTIMC: {
                    this.generateProfileCheckBox.setVisible(false);
                    this.copyProfilePathCheckBox.setVisible(true);
                    this.installButton.setText(Localization.get("gui.install.mmc"));
                    this.installLocation.setText(System.getProperty("user.dir"));
                    break;
                }
                default: {
                    throw new RuntimeException("don't know what to do with launcher type " + item);
                }
            }
        });
    }

    private void install(ActionEvent event) {
        String minecraftVersion = (String)this.minecraftVersionSelector.getSelectedItem();
        String loaderVersion = (String)this.loaderVersionSelector.getSelectedItem();
        LauncherType launcherType = this.launcherType();
        LoaderType loaderType = this.loaderType();
        InstallClient action = Action.installClient(minecraftVersion, launcherType, loaderType, loaderVersion, OptionalInt.empty(), this.intermediaryVersions().get(minecraftVersion), this.installLocation.getText(), this.generateProfile, this.copyProfilePath);
        AtomicReference result = new AtomicReference();
        ((Action)action).run(result::set);
        if (launcherType == LauncherType.MULTIMC) {
            ClientPanel.showMmcPackGenerationMessage(loaderType, this.copyProfilePath, (InstallMessageType)((Object)result.get()));
        } else {
            ClientPanel.showInstalledMessage(loaderType, (InstallMessageType)((Object)result.get()));
        }
    }

    private static void showMmcPackGenerationMessage(LoaderType type, boolean copyProfilePath, InstallMessageType msg) {
        if (msg == InstallMessageType.SUCCEED) {
            ClientPanel.showPopup(Localization.get("dialog.install.mmc.successful"), Localization.createFrom("dialog.install.mmc.successful.description", type.getLocalizedName(), "https://modrinth.com/mod/osl", copyProfilePath ? " " + Localization.get("dialog.install.mmc.copy-path") : ""), -1, 1);
        } else if (msg == InstallMessageType.FAIL) {
            ClientPanel.showPopup(Localization.get("dialog.install.mmc.failed"), Localization.get("dialog.install.mmc.failed"), -1, 1);
        }
    }

    LauncherType launcherType() {
        return ((LauncherLabel)this.launcherTypeSelector.getSelectedItem()).type;
    }

    @Override
    LoaderType loaderType() {
        return ((AbstractPanel.LoaderLabel)this.loaderTypeSelector.getSelectedItem()).type;
    }

    void receiveVersions(VersionManifest manifest, Map<LoaderType, List<String>> loaderVersions, List<Intermediary> intermediaryVersions) {
        super.receiveVersions(GameSide.CLIENT, manifest, loaderVersions, intermediaryVersions);
        ClientPanel.populateMinecraftVersions(GameSide.CLIENT, this.minecraftVersionSelector, this.manifest(), this.intermediaryVersions(), this.showSnapshots);
        this.showSnapshotsCheckBox.setEnabled(true);
        ClientPanel.populateLoaderVersions(GameSide.CLIENT, this.loaderVersionSelector, this.loaderVersions(this.loaderType()), this.showLoaderBetas);
        this.showLoaderBetasCheckBox.setEnabled(true);
        this.installButton.setText(Localization.get("gui.install"));
        this.installButton.setEnabled(true);
    }

    @Override
    public void accept(InstallMessageType messageType) {
    }

    class LauncherLabel
    extends JLabel {
        public final LauncherType type;

        public LauncherLabel(LauncherType type) {
            super(type.getLocalizedName());
            this.type = type;
        }

        @Override
        public String toString() {
            return this.getText();
        }
    }
}

