/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.lib.parsers.json;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.lib.parsers.json.JsonFormat;

public final class JsonWriter
implements Closeable,
Flushable {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private final Writer out;
    private final JsonFormat format;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String indent;
    private String separator;
    private boolean htmlSafe;
    private String deferredName;
    private String deferredComment;
    boolean inlineWaited;
    private boolean compact;
    private boolean serializeNulls;

    public static JsonWriter json5(Path out) throws IOException {
        return JsonWriter.create(out, JsonFormat.JSON5);
    }

    public static JsonWriter json5(Writer out) {
        return JsonWriter.create(out, JsonFormat.JSON5);
    }

    public static JsonWriter json(Path out) throws IOException {
        return JsonWriter.create(out, JsonFormat.JSON);
    }

    public static JsonWriter json(Writer out) {
        return JsonWriter.create(out, JsonFormat.JSON);
    }

    public static JsonWriter jsonc(Path out) throws IOException {
        return JsonWriter.create(out, JsonFormat.JSONC);
    }

    public static JsonWriter jsonc(Writer out) {
        return JsonWriter.create(out, JsonFormat.JSONC);
    }

    public static JsonWriter create(Path out, JsonFormat format) throws IOException {
        return new JsonWriter(Files.newBufferedWriter(Objects.requireNonNull(out, "Path cannot be null"), new OpenOption[0]), format);
    }

    public static JsonWriter create(Writer out, JsonFormat format) {
        return new JsonWriter(out, format);
    }

    private JsonWriter(Writer out, JsonFormat format) {
        this.push(6);
        this.indent = "\t";
        this.separator = ": ";
        this.inlineWaited = false;
        this.compact = false;
        this.serializeNulls = true;
        Objects.requireNonNull(out, "Writer cannot be null");
        this.out = out;
        this.format = format;
    }

    public void setIndent(String indent) {
        if (indent.length() == 0) {
            this.compact = true;
            this.indent = null;
            this.separator = ":";
        } else {
            this.compact = false;
            this.indent = indent;
            this.separator = ": ";
        }
    }

    public void setCompact() {
        this.setIndent("");
    }

    public boolean isCompact() {
        return this.indent == null;
    }

    public final void setHtmlSafe(boolean htmlSafe) {
        this.htmlSafe = htmlSafe;
    }

    public final boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public JsonWriter name(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.deferredName = name;
        return this;
    }

    public JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(3, '{');
    }

    public JsonWriter endObject() throws IOException {
        return this.close(3, 5, '}');
    }

    public JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(1, '[');
    }

    public JsonWriter endArray() throws IOException {
        return this.close(1, 2, ']');
    }

    public JsonWriter value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.string(value, true, true);
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(value ? "true" : "false");
        return this;
    }

    public JsonWriter value(@Nullable Boolean value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(value != false ? "true" : "false");
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        String string = value.toString();
        if (this.format != JsonFormat.JSON5 && (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.beforeValue();
        this.out.append(string);
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        this.writeDeferredName();
        if (this.format != JsonFormat.JSON5 && (Double.isNaN(value) || Double.isInfinite(value))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.beforeValue();
        this.out.append(Double.toString(value));
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(Long.toString(value));
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue();
        this.out.write("null");
        return this;
    }

    public JsonWriter jsonValue(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.append(value);
        return this;
    }

    public JsonWriter comment(String comment) throws IOException {
        if (this.compact || this.format == JsonFormat.JSON || comment == null) {
            return this;
        }
        this.deferredComment = this.deferredComment == null ? comment : this.deferredComment + "\n" + comment;
        if (this.stackSize == 1 && this.peek() == 7) {
            this.out.append('\n');
            this.writeDeferredComment();
        }
        return this;
    }

    public JsonWriter blockComment(@Nullable String comment) throws IOException {
        return this.comment(comment);
    }

    @Override
    public void flush() throws IOException {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.stack[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    private JsonWriter open(int empty, char openBracket) throws IOException {
        this.beforeValue();
        this.push(empty);
        this.out.write(openBracket);
        return this;
    }

    private JsonWriter close(int empty, int nonempty, char closeBracket) throws IOException {
        int context = this.peek();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException("Dangling name: " + this.deferredName);
        }
        --this.stackSize;
        if (context == nonempty) {
            this.commentAndNewline();
        }
        this.out.write(closeBracket);
        return this;
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stackSize * 2);
        }
        this.stack[this.stackSize++] = newTop;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int topOfStack) {
        this.stack[this.stackSize - 1] = topOfStack;
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            boolean quotes = true;
            if (this.format == JsonFormat.JSON5 && this.deferredName.length() > 0 && Character.isJavaIdentifierStart(this.deferredName.charAt(0))) {
                quotes = false;
                for (int i = 1; i < this.deferredName.length(); ++i) {
                    if (Character.isJavaIdentifierPart(this.deferredName.charAt(i))) continue;
                    quotes = true;
                    break;
                }
            }
            this.string(this.deferredName, quotes, true);
            this.deferredName = null;
        }
    }

    private void writeDeferredComment() throws IOException {
        if (this.deferredComment == null) {
            return;
        }
        for (String s : this.deferredComment.split("\n")) {
            int size = this.stackSize;
            for (int i = 1; i < size; ++i) {
                this.out.write(this.indent);
            }
            this.out.write("// ");
            this.string(s, false, false);
            this.out.write("\n");
        }
        this.deferredComment = null;
    }

    private void string(String value, boolean quotes, boolean escapeQuotes) throws IOException {
        String[] replacements;
        String[] stringArray = replacements = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        if (quotes) {
            this.out.write(34);
        }
        if (!escapeQuotes) {
            replacements[34] = null;
        }
        int last = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = value.charAt(i);
            if (c < '\u0080') {
                replacement = replacements[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                this.out.write(value, last, i - last);
            }
            this.out.write(replacement);
            last = i + 1;
        }
        if (last < length) {
            this.out.write(value, last, length - last);
        }
        if (quotes) {
            this.out.write(34);
        }
    }

    private void commentAndNewline() throws IOException {
        if (this.indent == null) {
            return;
        }
        this.out.write(10);
        this.writeDeferredComment();
        int size = this.stackSize;
        for (int i = 1; i < size; ++i) {
            this.out.write(this.indent);
        }
    }

    private void beforeName() throws IOException {
        int context = this.peek();
        if (context == 5) {
            this.out.write(44);
        } else if (context != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.commentAndNewline();
        this.replaceTop(4);
    }

    private void beforeValue() throws IOException {
        switch (this.peek()) {
            case 7: {
                throw new IllegalStateException("JSON must have only one top-level value.");
            }
            case 6: {
                this.writeDeferredComment();
                this.replaceTop(7);
                break;
            }
            case 1: {
                this.replaceTop(2);
                this.commentAndNewline();
                break;
            }
            case 2: {
                this.out.append(',');
                this.commentAndNewline();
                break;
            }
            case 4: {
                this.out.append(this.separator);
                this.replaceTop(5);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
        }
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonWriter.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JsonWriter.REPLACEMENT_CHARS[34] = "\\\"";
        JsonWriter.REPLACEMENT_CHARS[92] = "\\\\";
        JsonWriter.REPLACEMENT_CHARS[9] = "\\t";
        JsonWriter.REPLACEMENT_CHARS[8] = "\\b";
        JsonWriter.REPLACEMENT_CHARS[10] = "\\n";
        JsonWriter.REPLACEMENT_CHARS[13] = "\\r";
        JsonWriter.REPLACEMENT_CHARS[12] = "\\f";
        HTML_SAFE_REPLACEMENT_CHARS = (String[])REPLACEMENT_CHARS.clone();
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[60] = "\\u003c";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027";
    }
}

