/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.quiltmc.installer.GameSide;
import org.quiltmc.installer.LauncherType;
import org.quiltmc.installer.LoaderType;
import org.quiltmc.installer.OrnitheMeta;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.action.Action;

public final class CliInstaller {
    public static final String INSTALLER_VERSION = "0.12.1";

    public static void run(String[] args) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                builder.append(' ');
            }
            builder.append(args[i]);
        }
        Action<?> action = CliInstaller.parse(builder.toString());
        action.run(msg -> {
            if (action != Action.DISPLAY_HELP) {
                // empty if block
            }
        });
    }

    private static Action<?> parse(String input) {
        String arg;
        Queue<String> split = CliInstaller.splitQuoted(input);
        switch (arg = split.remove()) {
            case "help": {
                return Action.DISPLAY_HELP;
            }
            case "listVersions": {
                if (split.size() == 0) {
                    System.err.println("Loader type is required");
                    return Action.DISPLAY_HELP;
                }
                String rawType = split.remove();
                LoaderType type = LoaderType.of(rawType);
                if (type == null) {
                    System.err.println("Unknown loader type: " + rawType);
                    return Action.DISPLAY_HELP;
                }
                if (split.size() == 0) {
                    return Action.listVersions(type, false, false);
                }
                boolean minecraftSnapshots = false;
                boolean loaderBetas = false;
                boolean hasError = false;
                while (split.peek() != null) {
                    String option = split.remove();
                    if (option.equals("--snapshots")) {
                        minecraftSnapshots = true;
                        continue;
                    }
                    if (option.equals("--loader-betas")) {
                        loaderBetas = true;
                        continue;
                    }
                    if (option.startsWith("--")) {
                        System.err.printf("Invalid option \"%s\"%n", arg);
                        hasError = true;
                        continue;
                    }
                    System.err.printf("Unexpected additional argument \"%s\"%n", arg);
                    hasError = true;
                }
                return !hasError ? Action.listVersions(type, minecraftSnapshots, loaderBetas) : Action.DISPLAY_HELP;
            }
            case "install": {
                if (split.size() == 0) {
                    System.err.println("Side is required: \"client\" or \"server\"");
                    return Action.DISPLAY_HELP;
                }
                switch (arg = split.remove()) {
                    case "client": {
                        if (split.size() < 1) {
                            System.err.println("Minecraft version is required");
                            return Action.DISPLAY_HELP;
                        }
                        if (split.size() < 2) {
                            System.err.println("Launcher type is required");
                            return Action.DISPLAY_HELP;
                        }
                        if (split.size() < 3) {
                            System.err.println("Loader type is required");
                            return Action.DISPLAY_HELP;
                        }
                        String minecraftVersion = split.remove();
                        String rawLauncherType = split.remove();
                        String rawLoaderType = split.remove();
                        LauncherType launcherType = LauncherType.of(rawLauncherType);
                        LoaderType loaderType = LoaderType.of(rawLoaderType);
                        if (launcherType == null) {
                            System.err.println("Unknown launcher type: " + rawLauncherType);
                            return Action.DISPLAY_HELP;
                        }
                        if (loaderType == null) {
                            System.err.println("Unknown loader type: " + rawLoaderType);
                            return Action.DISPLAY_HELP;
                        }
                        String intermediary = CliInstaller.fetchIntermediary(GameSide.CLIENT, minecraftVersion);
                        if (split.size() == 0) {
                            return Action.installClient(minecraftVersion, launcherType, loaderType, null, intermediary, null, false, false);
                        }
                        String loaderVersion = null;
                        arg = split.peek();
                        if (!arg.startsWith("-")) {
                            loaderVersion = split.remove();
                        }
                        if (split.size() == 0) {
                            return Action.installClient(minecraftVersion, launcherType, loaderType, loaderVersion, intermediary, null, false, false);
                        }
                        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
                        while (split.peek() != null) {
                            String option = split.remove();
                            if (!option.startsWith("--")) {
                                System.err.printf("Invalid option %s%n", option);
                                return Action.DISPLAY_HELP;
                            }
                            if (option.equals("--no-profile")) {
                                if (options.containsKey("--no-profile")) {
                                    System.err.println("Encountered duplicate option \"--no-profile\", This shouldn't affect anything");
                                }
                                options.put("--no-profile", null);
                                continue;
                            }
                            if (option.equals("--copy-profile-path")) {
                                if (options.containsKey("--copy-profile-path")) {
                                    System.err.println("Encountered duplicate option \"--copy-profile-path\", This shouldn't affect anything");
                                }
                                options.put("--copy-profile-path", null);
                                continue;
                            }
                            if (option.startsWith("--install-dir")) {
                                if (options.containsKey("--install-dir")) {
                                    System.err.println("Encountered duplicate option \"--install-dir\"");
                                    return Action.DISPLAY_HELP;
                                }
                                if (option.indexOf(61) == -1) {
                                    System.err.println("Option \"--install-dir\" must specify a value");
                                    return Action.DISPLAY_HELP;
                                }
                                if (!option.startsWith("--install-dir=")) {
                                    System.err.println("Option \"--install-dir\" must have a equals sign (=) right after the option name to get the value");
                                    return Action.DISPLAY_HELP;
                                }
                                String value = CliInstaller.unqoute(option.substring(14));
                                if (value == null) {
                                    System.err.println("Option \"--install-dir\" must have value quoted at start and end of value");
                                    return Action.DISPLAY_HELP;
                                }
                                options.put("--install-dir", value);
                                continue;
                            }
                            System.err.printf("Invalid option %s%n", option);
                            return Action.DISPLAY_HELP;
                        }
                        return Action.installClient(minecraftVersion, launcherType, loaderType, loaderVersion, intermediary, (String)options.get("--install-dir"), !options.containsKey("--no-profile"), options.containsKey("--copy-profile-path"));
                    }
                    case "server": {
                        if (split.size() < 1) {
                            System.err.println("Minecraft version is required");
                            return Action.DISPLAY_HELP;
                        }
                        if (split.size() < 2) {
                            System.err.println("Loader type is required");
                            return Action.DISPLAY_HELP;
                        }
                        String minecraftVersion = split.remove();
                        String rawLoaderType = split.remove();
                        LoaderType loaderType = LoaderType.of(rawLoaderType);
                        if (loaderType == null) {
                            System.err.println("Unknown loader type: " + rawLoaderType);
                            return Action.DISPLAY_HELP;
                        }
                        if (split.size() == 0) {
                            return Action.installServer(minecraftVersion, loaderType, null, null, false, false);
                        }
                        String loaderVersion = null;
                        arg = split.peek();
                        if (!arg.startsWith("-")) {
                            loaderVersion = split.remove();
                        }
                        if (split.size() == 0) {
                            return Action.installServer(minecraftVersion, loaderType, loaderVersion, null, false, false);
                        }
                        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
                        while (split.peek() != null) {
                            String option = split.remove();
                            if (!option.startsWith("--")) {
                                System.err.printf("Invalid option %s%n", option);
                            }
                            if (option.equals("--create-scripts")) {
                                if (options.containsKey("--create-scripts")) {
                                    System.err.println("Encountered duplicate option \"--create-scripts\", This shouldn't affect anything");
                                }
                                options.put("--create-scripts", null);
                                continue;
                            }
                            if (option.equals("--download-server")) {
                                if (options.containsKey("--download-server")) {
                                    System.err.println("Encountered duplicate option \"--download-server\", This shouldn't affect anything");
                                }
                                options.put("--download-server", null);
                                continue;
                            }
                            if (option.startsWith("--install-dir")) {
                                if (options.containsKey("--install-dir")) {
                                    System.err.println("Encountered duplicate option \"--install-dir\"");
                                    return Action.DISPLAY_HELP;
                                }
                                if (option.indexOf(61) == -1) {
                                    System.err.println("Option \"--install-dir\" must specify a value");
                                    return Action.DISPLAY_HELP;
                                }
                                if (!option.startsWith("--install-dir=")) {
                                    System.err.println("Option \"--install-dir\" must have a equals sign (=) right after the option name to get the value");
                                    return Action.DISPLAY_HELP;
                                }
                                String value = CliInstaller.unqoute(option.substring(14));
                                if (value == null) {
                                    System.err.println("Option \"--install-dir\" must have value quoted at start and end of value");
                                    return Action.DISPLAY_HELP;
                                }
                                options.put("--install-dir", value);
                                continue;
                            }
                            System.err.printf("Invalid option %s%n", option);
                            return Action.DISPLAY_HELP;
                        }
                        return Action.installServer(minecraftVersion, loaderType, loaderVersion, (String)options.get("--install-dir"), options.containsKey("--create-scripts"), options.containsKey("--download-server"));
                    }
                }
                System.err.printf("Invalid side \"%s\", expected \"client\" or \"server\"%n", arg);
                return Action.DISPLAY_HELP;
            }
        }
        System.err.printf("Invalid argument \"%s\"%n", arg);
        return Action.DISPLAY_HELP;
    }

    private static String fetchIntermediary(GameSide side, String minecraftVersion) {
        return (String)((CompletableFuture)OrnitheMeta.create("https://meta.ornithemc.net", Set.of(OrnitheMeta.INTERMEDIARY_VERSIONS_ENDPOINT)).thenApply(meta -> {
            VersionManifest manifest = VersionManifest.create().join();
            VersionManifest.Version version = manifest.getVersion(minecraftVersion);
            return meta.getEndpoint(OrnitheMeta.INTERMEDIARY_VERSIONS_ENDPOINT).get(version.id(side));
        })).join();
    }

    private static Queue<String> splitQuoted(String input) {
        LinkedList<String> ret = new LinkedList<String>();
        boolean inQuote = false;
        int lastEnd = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"') {
                inQuote = !inQuote;
                continue;
            }
            if (c != ' ' || inQuote) continue;
            String word = input.substring(lastEnd, i);
            ret.add(word);
            lastEnd = i + 1;
        }
        String word = input.substring(lastEnd);
        ret.add(word);
        if (inQuote) {
            throw new IllegalArgumentException("Unterminated \" found");
        }
        return ret;
    }

    private static String unqoute(String input) {
        if (input.indexOf(34) == -1) {
            return input;
        }
        if (input.indexOf(34) != 0) {
            return null;
        }
        if (input.charAt(input.length() - 1) != '\"') {
            return null;
        }
        return input.substring(1, input.length() - 1);
    }
}

