/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.quiltmc.installer.Connections;
import org.quiltmc.installer.GameSide;
import org.quiltmc.installer.Gsons;
import org.quiltmc.installer.LoaderType;
import org.quiltmc.installer.OrnitheMeta;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.lib.parsers.json.JsonReader;
import org.quiltmc.installer.lib.parsers.json.JsonWriter;

public final class LaunchJson {
    public static CompletableFuture<String> getMmcJson(VersionManifest.Version gameVersion) {
        return LaunchJson.get(gameVersion).thenApply(vanillaJson -> {
            try {
                Map arguments;
                Map vanillaMap = (Map)Gsons.read(JsonReader.json(vanillaJson));
                String clientName = "com.mojang:minecraft:" + gameVersion.id() + ":client";
                Map downloads = (Map)vanillaMap.get("downloads");
                Map client = (Map)downloads.get("client");
                Map<String, Object> mainJar = Map.of("downloads", Map.of("artifact", client), "name", clientName);
                List vanillaLibraries = (List)vanillaMap.get("libraries");
                vanillaLibraries.removeIf(lib -> ((String)lib.get("name")).contains("org.lwjgl"));
                ArrayList<String> traits = new ArrayList<String>();
                if (((String)vanillaMap.get("mainClass")).contains("launchwrapper")) {
                    traits.add("texturepacks");
                }
                String minecraftArguments = vanillaMap.getOrDefault("minecraftArguments", "");
                if (vanillaMap.containsKey("arguments") && !(arguments = (Map)vanillaMap.get("arguments")).isEmpty()) {
                    List gameArguments = (List)arguments.get("game");
                    if (!arguments.isEmpty()) {
                        Object combinedCombination = "";
                        for (Object gameArgument : gameArguments) {
                            if (!(gameArgument instanceof String)) continue;
                            combinedCombination = (String)combinedCombination + gameArgument + " ";
                        }
                        minecraftArguments = ((String)combinedCombination).trim();
                        traits.add("FirstThreadOnMacOS");
                    }
                }
                StringWriter writer = new StringWriter();
                Gsons.write(JsonWriter.json(writer), LaunchJson.buildPackJsonMap(vanillaMap, vanillaLibraries, minecraftArguments, traits, mainJar, gameVersion.id()));
                return writer.toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Map<String, Object> buildPackJsonMap(Map<String, Object> vanilaMap, List<Map<String, String>> modifiedLibraries, String minecraftArguments, List<String> traits, Map<String, Object> mainJar, String gameVersion) {
        LinkedHashMap<String, Object> moddedJsonMap = new LinkedHashMap<String, Object>();
        if (!traits.isEmpty()) {
            moddedJsonMap.put("+traits", traits);
        }
        moddedJsonMap.put("assetIndex", vanilaMap.get("assetIndex"));
        moddedJsonMap.put("compatibleJavaMajors", List.of(Integer.valueOf(8)));
        moddedJsonMap.put("formatVersion", 1);
        moddedJsonMap.put("libraries", modifiedLibraries);
        moddedJsonMap.put("mainClass", vanilaMap.get("mainClass"));
        moddedJsonMap.put("mainJar", mainJar);
        moddedJsonMap.put("minecraftArguments", minecraftArguments);
        moddedJsonMap.put("name", "Minecraft");
        moddedJsonMap.put("releaseTime", vanilaMap.get("releaseTime"));
        moddedJsonMap.put("requires", List.of(Map.of("suggests", "${lwjgl_version}", "uid", "${lwjgl_uid}")));
        moddedJsonMap.put("type", vanilaMap.get("type"));
        moddedJsonMap.put("uid", "net.minecraft");
        moddedJsonMap.put("version", gameVersion);
        return moddedJsonMap;
    }

    public static CompletableFuture<String> get(VersionManifest.Version gameVersion) {
        String rawUrl = String.format("https://skyrising.github.io/mc-versions/version/manifest/%s.json", gameVersion.id());
        return CompletableFuture.supplyAsync(() -> {
            try {
                Map map;
                URL url = new URL(rawUrl);
                URLConnection connection = Connections.openConnection(url);
                try (InputStreamReader input = new InputStreamReader(connection.getInputStream());){
                    map = (Map)Gsons.read(JsonReader.json(input));
                }
                for (String rawManifestUrl : gameVersion.details().manifests()) {
                    URL manifestUrl = new URL(rawManifestUrl);
                    URLConnection manifestConnection = Connections.openConnection(manifestUrl);
                    try (InputStreamReader input = new InputStreamReader(manifestConnection.getInputStream());){
                        LaunchJson.buildVersionJsonFromManifest(map, (Map)Gsons.read(JsonReader.json(input)));
                    }
                }
                map.put("id", String.format("%s-vanilla", gameVersion.id()));
                List libs = (List)map.get("libraries");
                libs.removeIf(lib -> ((String)lib.get("name")).contains("org.ow2.asm"));
                StringWriter writer = new StringWriter();
                Gsons.write(JsonWriter.json(writer), map);
                return writer.toString();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private static void buildVersionJsonFromManifest(Map<String, Object> versionJson, Map<String, Object> manifest) {
        for (String key : manifest.keySet()) {
            if (versionJson.containsKey(key)) {
                Object manifestElement;
                Object versionJsonElement = versionJson.get(key);
                if (versionJsonElement.equals(manifestElement = manifest.get(key)) || !(versionJsonElement instanceof Map) || !(manifestElement instanceof Map)) continue;
                LaunchJson.buildVersionJsonFromManifest((Map)versionJsonElement, (Map)manifestElement);
                continue;
            }
            versionJson.put(key, manifest.get(key));
        }
    }

    public static CompletableFuture<String> get(GameSide side, VersionManifest.Version gameVersion, LoaderType type, String loaderVersion) {
        String rawUrl = "https://meta.ornithemc.net" + String.format(side.launchJsonEndpoint(), type.getName(), gameVersion.id(side), loaderVersion);
        return CompletableFuture.supplyAsync(() -> {
            String string;
            URL url = new URL(rawUrl);
            URLConnection connection = Connections.openConnection(url);
            InputStreamReader stream = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
            BufferedReader reader = new BufferedReader(stream);
            try {
                String line;
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                    builder.append('\n');
                }
                string = builder.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
            return string;
        }).thenApplyAsync(raw -> {
            Map map;
            try {
                map = (Map)Gsons.read(JsonReader.json(raw));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            OrnitheMeta.Endpoint<List<Map<String, String>>> libraryUpgradesEndpoint = OrnitheMeta.libraryUpgradesEndpoint(gameVersion.id());
            OrnitheMeta meta = OrnitheMeta.create("https://meta.ornithemc.net", Collections.singleton(libraryUpgradesEndpoint)).join();
            List<Map<String, String>> libraryUpgrades = meta.getEndpoint(libraryUpgradesEndpoint);
            if (type == LoaderType.QUILT) {
                switch (loaderVersion) {
                    case "0.19.2": 
                    case "0.19.3": 
                    case "0.19.4": {
                        Map arguments = (Map)map.get("arguments");
                        arguments.computeIfAbsent("jvm", key -> new ArrayList()).add("-Dloader.disable_beacon=true");
                        break;
                    }
                }
            }
            List libraries = (List)map.get("libraries");
            for (Map library : libraries) {
                if (((String)library.get("name")).startsWith("net.fabricmc:intermediary")) {
                    library.replace("name", ((String)library.get("name")).replace("net.fabricmc:intermediary", "net.ornithemc:calamus-intermediary"));
                    library.replace("url", "https://maven.ornithemc.net/releases/");
                }
                if (!((String)library.get("name")).startsWith("org.quiltmc:hashed")) continue;
                library.replace("name", ((String)library.get("name")).replace("org.quiltmc:hashed", "net.ornithemc:calamus-intermediary"));
                library.replace("url", "https://maven.ornithemc.net/releases/");
            }
            libraries.addAll(libraryUpgrades);
            StringWriter writer = new StringWriter();
            try {
                Gsons.write(JsonWriter.json(writer), map);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return writer.toString();
        });
    }

    private LaunchJson() {
    }
}

