/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import org.quiltmc.installer.Localization;

public enum LoaderType {
    FABRIC("net.fabricmc.fabric-loader"),
    QUILT("org.quiltmc.quilt-loader");

    private final String name = this.name().toLowerCase();
    private final String mavenUid;
    private String localizedName;

    private LoaderType(String uid) {
        this.mavenUid = uid;
    }

    public String getName() {
        return this.name;
    }

    public String getMavenUid() {
        return this.mavenUid;
    }

    public String getLocalizedName() {
        if (this.localizedName == null) {
            this.localizedName = Localization.get("gui.loader.type." + this.name);
        }
        return this.localizedName;
    }

    public static LoaderType of(String name) {
        return LoaderType.valueOf(name.toUpperCase());
    }
}

