/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.quiltmc.installer.Connections;
import org.quiltmc.installer.Gsons;
import org.quiltmc.installer.LaunchJson;
import org.quiltmc.installer.LoaderType;
import org.quiltmc.installer.OrnitheMeta;
import org.quiltmc.installer.ParseException;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.lib.parsers.json.JsonReader;
import org.quiltmc.installer.lib.parsers.json.JsonToken;
import org.quiltmc.installer.lib.parsers.json.JsonWriter;

public class MmcPackCreator {
    private static final String ENV_WRAPPER_COMMAND = "WrapperCommand=env __GL_THREADED_OPTIMIZATIONS=0";
    private static final boolean IS_LINUX_LIKE_OS;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findLwjglVersion(VersionManifest manifest, String gameVersion) {
        Iterator<String> iterator = manifest.getVersion(gameVersion).details().manifests().iterator();
        while (iterator.hasNext()) {
            String rawUrl = iterator.next();
            try {
                URL url = new URL(rawUrl);
                URLConnection connection = Connections.openConnection(url);
                JsonReader reader = JsonReader.json(new BufferedReader(new InputStreamReader(connection.getInputStream())));
                try {
                    String lwjglVersion = MmcPackCreator.findLwjglVersion(reader);
                    if (lwjglVersion == null) continue;
                    String string = lwjglVersion;
                    return string;
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("issue while finding lwjgl version for Minecraft " + gameVersion, e);
            }
        }
        throw new RuntimeException("unable to find lwjgl version for Minecraft " + gameVersion);
    }

    private static String findLwjglVersion(JsonReader reader) throws IOException, ParseException {
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            throw new ParseException("Version Manifest was invalid type", reader);
        }
        reader.beginObject();
        block12: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "libraries": {
                    if (reader.peek() != JsonToken.BEGIN_ARRAY) {
                        throw new ParseException("libraries must be an array", reader);
                    }
                    reader.beginArray();
                    while (reader.hasNext()) {
                        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                            throw new ParseException("library entries must all be objects", reader);
                        }
                        reader.beginObject();
                        block14: while (reader.hasNext()) {
                            switch (reader.nextName()) {
                                case "name": {
                                    if (reader.peek() != JsonToken.STRING) {
                                        throw new ParseException("library name must be a string", reader);
                                    }
                                    String name = reader.nextString();
                                    String[] maven = name.split("[:]");
                                    String artifact = maven[1];
                                    String version = maven[2];
                                    if (!artifact.equals("lwjgl")) continue block14;
                                    return version;
                                }
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                    }
                    reader.endArray();
                    continue block12;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return null;
    }

    private static String transformPackJson(String examplePackJson, String gameVersion, LoaderType type, String loaderVersion, String lwjglVersion, String intermediaryVersion) {
        String lwjglMajorVer = lwjglVersion.substring(0, 1);
        return examplePackJson.replaceAll("\\$\\{mc_version}", gameVersion).replaceAll("\\$\\{intermediary_ver}", intermediaryVersion).replaceAll("\\$\\{loader_version}", loaderVersion).replaceAll("\\$\\{loader_name}", type.getLocalizedName() + " Loader").replaceAll("\\$\\{loader_uid}", type.getMavenUid()).replaceAll("\\$\\{lwjgl_version}", lwjglVersion).replaceAll("\\$\\{lwjgl_major_ver}", lwjglMajorVer).replaceAll("\\$\\{lwjgl_uid}", lwjglMajorVer.equals("3") ? "org.lwjgl3" : "org.lwjgl");
    }

    private static String transformMinecraftJson(String minecraftPatchString, String lwjglVersion) {
        String lwjglMajorVer = lwjglVersion.substring(0, 1);
        return minecraftPatchString.replaceAll("\\$\\{lwjgl_version}", lwjglVersion).replaceAll("\\$\\{lwjgl_uid}", lwjglMajorVer.equals("3") ? "org.lwjgl3" : "org.lwjgl");
    }

    private static String addLibraryUpgrades(Path instanceZipRoot, String gameVersion, LoaderType loaderType, String loaderVersion, String packJson) throws IOException {
        String patch = "{\"formatVersion\": 1, \"libraries\": [{\"name\": \"%s\",\"url\": \"%s\"}],\"name\": \"%s\",\"type\": \"release\",\"uid\": \"%s\",\"version\": \"%s\"}";
        OrnitheMeta.Endpoint<List<Map<String, String>>> librariesEndpoint = OrnitheMeta.libraryUpgradesEndpoint(gameVersion);
        OrnitheMeta meta = OrnitheMeta.create("https://meta.ornithemc.net", Collections.singleton(librariesEndpoint)).join();
        List<Map<String, String>> libraries = meta.getEndpoint(librariesEndpoint);
        Map pack = (Map)Gsons.read(JsonReader.json(packJson));
        List components = (List)pack.get("components");
        for (Map<String, String> map : libraries) {
            String name = map.get("name");
            String url = map.get("url");
            String uid = name.substring(0, name.lastIndexOf(58)).replace(":", ".");
            String libName = name.substring(name.indexOf(58) + 1, name.lastIndexOf(58));
            String version = name.substring(name.lastIndexOf(58) + 1);
            Files.writeString(instanceZipRoot.resolve("patches").resolve(uid + ".json"), (CharSequence)String.format(patch, name, url, libName, uid, version), new OpenOption[0]);
            components.add(Map.of("cachedName", libName, "cachedVersion", version, "uid", uid));
        }
        StringWriter writer = new StringWriter();
        Gsons.write(JsonWriter.json(writer), pack);
        return writer.toString();
    }

    public static void compileMmcZip(Path outPutDir, String gameVersion, LoaderType loaderType, String loaderVersion, String intermediaryInfo, VersionManifest manifest, boolean copyProfilePath) {
        String examplePackDir = "/packformat";
        String packJsonPath = "mmc-pack.json";
        String intermediaryJsonPath = "patches/net.fabricmc.intermediary.json";
        String instanceCfgPath = "instance.cfg";
        String iconPath = "ornithe.png";
        String minecraftPatchPath = "patches/net.minecraft.json";
        VersionManifest.Version version = manifest.getVersion(gameVersion);
        String[] intermediaryParts = intermediaryInfo.split("[:]");
        String intermediaryMaven = intermediaryParts[0] + ":" + intermediaryParts[1];
        String intermediaryVersion = intermediaryParts[2];
        try {
            String lwjglVersion = MmcPackCreator.findLwjglVersion(manifest, gameVersion);
            String transformedPackJson = MmcPackCreator.transformPackJson(MmcPackCreator.readResource(examplePackDir, packJsonPath), gameVersion, loaderType, loaderVersion, lwjglVersion, intermediaryVersion);
            String transformedIntermediaryJson = MmcPackCreator.readResource(examplePackDir, intermediaryJsonPath).replaceAll("\\$\\{mc_version}", gameVersion).replaceAll("\\$\\{intermediary_ver}", intermediaryVersion).replaceAll("\\$\\{intermediary_maven}", intermediaryMaven);
            Object transformedInstanceCfg = MmcPackCreator.readResource(examplePackDir, instanceCfgPath).replaceAll("\\$\\{mc_version}", gameVersion);
            String transformedMinecraftJson = MmcPackCreator.transformMinecraftJson(LaunchJson.getMmcJson(version).join(), lwjglVersion);
            if (IS_LINUX_LIKE_OS) {
                transformedInstanceCfg = (String)transformedInstanceCfg + "\nOverrideCommands=true\nWrapperCommand=env __GL_THREADED_OPTIMIZATIONS=0";
            }
            Path zipFile = outPutDir.resolve("Ornithe-" + gameVersion + ".zip");
            Files.deleteIfExists(zipFile);
            try (FileSystem fs = FileSystems.newFileSystem(zipFile, Map.of("create", "true"));){
                Files.copy(MmcPackCreator.class.getResourceAsStream(examplePackDir + "/" + iconPath), fs.getPath(iconPath, new String[0]), new CopyOption[0]);
                Files.writeString(fs.getPath(instanceCfgPath, new String[0]), (CharSequence)transformedInstanceCfg, new OpenOption[0]);
                Files.createDirectory(fs.getPath("patches", new String[0]), new FileAttribute[0]);
                Files.writeString(fs.getPath(intermediaryJsonPath, new String[0]), (CharSequence)transformedIntermediaryJson, new OpenOption[0]);
                Files.writeString(fs.getPath(minecraftPatchPath, new String[0]), (CharSequence)transformedMinecraftJson, new OpenOption[0]);
                String packJsonWithLibraries = MmcPackCreator.addLibraryUpgrades(fs.getPath("/", new String[0]), gameVersion, loaderType, loaderVersion, transformedPackJson);
                Files.writeString(fs.getPath(packJsonPath, new String[0]), (CharSequence)packJsonWithLibraries, new OpenOption[0]);
            }
            if (copyProfilePath) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(zipFile.toString()), null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String readResource(String dir, String path) throws IOException {
        int length;
        InputStream resource = MmcPackCreator.class.getResourceAsStream(String.format("%s/%s", dir, path));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = resource.read(buffer)) != -1) {
            os.write(buffer, 0, length);
        }
        return os.toString(StandardCharsets.UTF_8);
    }

    static {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        IS_LINUX_LIKE_OS = os.contains("linux") || !os.contains("win") && !os.contains("mac");
    }
}

