/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.quiltmc.installer.Connections;
import org.quiltmc.installer.Gsons;
import org.quiltmc.installer.LoaderType;
import org.quiltmc.installer.ParseException;
import org.quiltmc.installer.ThrowingFunction;
import org.quiltmc.installer.lib.parsers.json.JsonReader;
import org.quiltmc.installer.lib.parsers.json.JsonToken;

public final class OrnitheMeta {
    public static final Endpoint<List<String>> FABRIC_LOADER_VERSIONS_ENDPOINT = OrnitheMeta.createVersion("/v3/versions/fabric-loader");
    public static final Endpoint<List<String>> QUILT_LOADER_VERSIONS_ENDPOINT = OrnitheMeta.createVersion("/v3/versions/quilt-loader");
    public static final Endpoint<Map<String, String>> INTERMEDIARY_VERSIONS_ENDPOINT = new Endpoint<Map>("/v3/versions/intermediary", reader -> {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (reader.peek() != JsonToken.BEGIN_ARRAY) {
            throw new ParseException("Intermediary versions must be in an array", (JsonReader)reader);
        }
        reader.beginArray();
        while (reader.hasNext()) {
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                throw new ParseException("Intermediary version entry must be an object", (JsonReader)reader);
            }
            reader.beginObject();
            String version = null;
            String maven = null;
            while (reader.hasNext()) {
                if (reader.peek() != JsonToken.NAME) {
                    reader.skipValue();
                    continue;
                }
                switch (reader.nextName()) {
                    case "version": {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseException("Version must be a string", (JsonReader)reader);
                        }
                        version = reader.nextString();
                        break;
                    }
                    case "maven": {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseException("maven must be a string", (JsonReader)reader);
                        }
                        maven = reader.nextString();
                        break;
                    }
                    case "stable": {
                        reader.nextBoolean();
                    }
                }
            }
            if (version == null) {
                throw new ParseException("Intermediary version entry does not have a version field", (JsonReader)reader);
            }
            if (maven == null) {
                throw new ParseException("Intermediary version entry does not have a maven field", (JsonReader)reader);
            }
            ret.put(version, maven);
            reader.endObject();
        }
        reader.endArray();
        return ret;
    });
    public static final String ORNITHE_META_URL = "https://meta.ornithemc.net";
    private final Map<Endpoint<?>, Object> endpoints;

    public static Endpoint<List<Map<String, String>>> libraryUpgradesEndpoint(String gameVersion) {
        return new Endpoint<List<Map<String, String>>>(String.format("/v3/versions/libraries/%s", gameVersion), reader -> (List)Gsons.read(reader));
    }

    public static Endpoint<List<String>> loaderVersionsEndpoint(LoaderType type) {
        switch (type) {
            case FABRIC: {
                return FABRIC_LOADER_VERSIONS_ENDPOINT;
            }
            case QUILT: {
                return QUILT_LOADER_VERSIONS_ENDPOINT;
            }
        }
        throw new IllegalStateException("no endpoints for loader type " + type.getName());
    }

    public static CompletableFuture<OrnitheMeta> create(String baseMetaUrl, Set<Endpoint<?>> endpoints) {
        HashMap futures = new HashMap();
        for (Endpoint<?> endpoint : endpoints) {
            futures.put(endpoint, CompletableFuture.supplyAsync(() -> {
                Object t;
                block8: {
                    URL url = new URL(baseMetaUrl + endpoint.endpointPath);
                    URLConnection connection = Connections.openConnection(url);
                    InputStreamReader stream = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
                    JsonReader reader = JsonReader.json(new BufferedReader(stream));
                    try {
                        t = endpoint.deserializer.apply(reader);
                        if (reader == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    reader.close();
                }
                return t;
            }));
        }
        CompletableFuture<Void> future = CompletableFuture.allOf(futures.values().toArray(new CompletableFuture[0]));
        return future.thenApply(_v -> {
            HashMap resolvedEndpoints = new HashMap();
            for (Map.Entry entry : futures.entrySet()) {
                resolvedEndpoints.put((Endpoint)entry.getKey(), ((CompletableFuture)entry.getValue()).join());
            }
            return new OrnitheMeta(baseMetaUrl, resolvedEndpoints);
        });
    }

    private static Endpoint<List<String>> createVersion(String endpointPath) {
        return new Endpoint<List<String>>(endpointPath, reader -> {
            if (reader.peek() != JsonToken.BEGIN_ARRAY) {
                throw new ParseException("Result of endpoint must be an object", (JsonReader)reader);
            }
            ArrayList<String> versions = new ArrayList<String>();
            reader.beginArray();
            while (reader.hasNext()) {
                if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                    throw new ParseException("Version entry must be an object", (JsonReader)reader);
                }
                String version = null;
                reader.beginObject();
                while (reader.hasNext()) {
                    String key = reader.nextName();
                    if ("version".equals(key)) {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseException("\"version\" in entry must be a string", (JsonReader)reader);
                        }
                        version = reader.nextString();
                        continue;
                    }
                    reader.skipValue();
                }
                if (version == null) {
                    throw new ParseException("\"version\" field is required in a version entry", (JsonReader)reader);
                }
                versions.add(version);
                reader.endObject();
            }
            reader.endArray();
            return versions;
        });
    }

    private OrnitheMeta(String baseMetaUrl, Map<Endpoint<?>, Object> endpoints) {
        this.endpoints = endpoints;
    }

    public <T> T getEndpoint(Endpoint<T> endpoint) {
        Objects.requireNonNull(endpoint, "Endpoint cannot be null");
        Object result = this.endpoints.get(endpoint);
        if (result == null) {
            throw new IllegalArgumentException("Endpoint had no value!");
        }
        return (T)result;
    }

    public static final class Endpoint<T> {
        private final String endpointPath;
        private final ThrowingFunction<JsonReader, T, ParseException> deserializer;

        Endpoint(String endpointPath, ThrowingFunction<JsonReader, T, ParseException> deserializer) {
            this.endpointPath = endpointPath;
            this.deserializer = deserializer;
        }

        public String toString() {
            return "Endpoint{endpointPath=\"" + this.endpointPath + "\"";
        }
    }
}

