/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.Connections;
import org.quiltmc.installer.GameSide;
import org.quiltmc.installer.ParseException;
import org.quiltmc.installer.lib.parsers.json.JsonReader;
import org.quiltmc.installer.lib.parsers.json.JsonToken;

public final class VersionManifest
implements Collection<Version> {
    public static final String LAUNCHER_META_URL = "https://skyrising.github.io/mc-versions/version_manifest.json";
    public static final String VERSION_META_URL = "https://skyrising.github.io/mc-versions/version/manifest/%s.json";
    private final Version latestRelease;
    private final Version latestSnapshot;
    private final Map<String, Version> versions;

    public static CompletableFuture<VersionManifest> create() {
        return CompletableFuture.supplyAsync(() -> {
            VersionManifest versionManifest;
            block8: {
                URL url = new URL(LAUNCHER_META_URL);
                URLConnection connection = Connections.openConnection(url);
                InputStreamReader stream = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
                JsonReader reader = JsonReader.json(new BufferedReader(stream));
                try {
                    versionManifest = VersionManifest.read(reader);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                reader.close();
            }
            return versionManifest;
        });
    }

    private static VersionManifest read(JsonReader reader) throws IOException, ParseException {
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            throw new ParseException("Launcher Meta was invalid type", reader);
        }
        LinkedHashMap<String, Version> versions = new LinkedHashMap<String, Version>();
        @Nullable String latestRelease = null;
        @Nullable String latestSnapshot = null;
        reader.beginObject();
        block16: while (reader.hasNext()) {
            String key;
            switch (key = reader.nextName()) {
                case "latest": {
                    if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                        throw new ParseException("Latest versions must be an object", reader);
                    }
                    reader.beginObject();
                    block17: while (reader.hasNext()) {
                        String latestType = reader.nextName();
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseException(String.format("Latest \"%s\" must have a string value", latestType), reader);
                        }
                        switch (latestType) {
                            case "release": {
                                latestRelease = reader.nextString();
                                continue block17;
                            }
                            case "snapshot": {
                                latestSnapshot = reader.nextString();
                                continue block17;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block16;
                }
                case "versions": {
                    VersionManifest.readVersions(reader, versions);
                    continue block16;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        Version latestReleaseVersion = (Version)versions.get(latestRelease);
        Version latestSnapshotVersion = (Version)versions.get(latestSnapshot);
        return new VersionManifest(latestReleaseVersion, latestSnapshotVersion, versions);
    }

    private static void readVersions(JsonReader reader, Map<String, Version> versions) throws IOException, ParseException {
        if (reader.peek() != JsonToken.BEGIN_ARRAY) {
            throw new ParseException("Versions must be in an array", reader);
        }
        reader.beginArray();
        while (reader.hasNext()) {
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                throw new ParseException("Version entries must all be objects", reader);
            }
            reader.beginObject();
            String id = null;
            String type = null;
            String url = null;
            String time = null;
            String releaseTime = null;
            String details = null;
            block17: while (reader.hasNext()) {
                String key;
                switch (key = reader.nextName()) {
                    case "id": {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseException("Version id must be a string", reader);
                        }
                        id = reader.nextString();
                        continue block17;
                    }
                    case "type": {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseException("Version type must be a string", reader);
                        }
                        type = reader.nextString();
                        continue block17;
                    }
                    case "url": {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseException("Version url must be a string", reader);
                        }
                        url = reader.nextString();
                        continue block17;
                    }
                    case "time": {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseException("Version time must be a string", reader);
                        }
                        time = reader.nextString();
                        continue block17;
                    }
                    case "releaseTime": {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseException("Version release time must be a string", reader);
                        }
                        releaseTime = reader.nextString();
                        continue block17;
                    }
                    case "details": {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseException("Details url must be a string", reader);
                        }
                        details = reader.nextString();
                        continue block17;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (id == null) {
                throw new ParseException("Version id is required", reader);
            }
            if (type == null) {
                throw new ParseException("Version type is required", reader);
            }
            if (url == null) {
                throw new ParseException("Version url is required", reader);
            }
            if (details == null) {
                throw new ParseException("Details url is required", reader);
            }
            versions.put(id, new Version(id, type, url, time, releaseTime, details));
        }
        reader.endArray();
    }

    private static VersionDetails readDetails(Version version) {
        VersionDetails versionDetails;
        block8: {
            URL url = new URL(version.detailsUrl);
            URLConnection connection = url.openConnection();
            InputStreamReader stream = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
            JsonReader reader = JsonReader.json(new BufferedReader(stream));
            try {
                versionDetails = VersionManifest.readDetails(version, reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
        }
        return versionDetails;
    }

    private static VersionDetails readDetails(Version version, JsonReader reader) throws IOException, ParseException {
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            throw new ParseException("Version Details was invalid type", reader);
        }
        List<String> manifests = null;
        Boolean sharedMappings = null;
        String normalizedVersion = null;
        reader.beginObject();
        block10: while (reader.hasNext()) {
            String key;
            switch (key = reader.nextName()) {
                case "manifests": {
                    if (reader.peek() != JsonToken.BEGIN_ARRAY) {
                        throw new ParseException("manifests must be an array", reader);
                    }
                    manifests = VersionManifest.readManifests(version, reader);
                    continue block10;
                }
                case "sharedMappings": {
                    if (reader.peek() != JsonToken.BOOLEAN) {
                        throw new ParseException("sharedMappings must be a boolean", reader);
                    }
                    sharedMappings = reader.nextBoolean();
                    continue block10;
                }
                case "normalizedVersion": {
                    if (reader.peek() != JsonToken.STRING) {
                        throw new ParseException("normalizedVersion must be a string", reader);
                    }
                    normalizedVersion = reader.nextString();
                    continue block10;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (manifests == null) {
            throw new ParseException("manifests is required", reader);
        }
        if (sharedMappings == null) {
            throw new ParseException("sharedMappings is required", reader);
        }
        if (normalizedVersion == null) {
            throw new ParseException("normalizedVersion is required", reader);
        }
        return new VersionDetails(version, normalizedVersion, manifests, sharedMappings);
    }

    private static List<String> readManifests(Version version, JsonReader reader) throws IOException, ParseException {
        if (reader.peek() != JsonToken.BEGIN_ARRAY) {
            throw new ParseException("Versions manifests must be in an array", reader);
        }
        ArrayList<String> manifests = new ArrayList<String>();
        reader.beginArray();
        while (reader.hasNext()) {
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                throw new ParseException("Version manifest entries must all be objects", reader);
            }
            reader.beginObject();
            block7: while (reader.hasNext()) {
                String key;
                switch (key = reader.nextName()) {
                    case "url": {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseException("Version url must be a string", reader);
                        }
                        manifests.add(reader.nextString());
                        continue block7;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
        }
        reader.endArray();
        return Collections.unmodifiableList(manifests);
    }

    private VersionManifest(Version latestRelease, Version latestSnapshot, Map<String, Version> versions) {
        this.latestRelease = latestRelease;
        this.latestSnapshot = latestSnapshot;
        this.versions = versions;
    }

    @Nullable
    public Version getVersion(String id) {
        return this.versions.get(id);
    }

    public Version latestRelease() {
        return this.latestRelease;
    }

    public Version latestSnapshot() {
        return this.latestSnapshot;
    }

    @Override
    public int size() {
        return this.versions.size();
    }

    @Override
    public boolean isEmpty() {
        return this.versions.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof String) {
            return this.versions.containsKey(o);
        }
        return o instanceof Version && this.versions.containsValue(o);
    }

    @Override
    public Iterator<Version> iterator() {
        return Collections.unmodifiableMap(this.versions).values().iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.versions.values().toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(T[] a) {
        return this.versions.values().toArray(a);
    }

    @Override
    public boolean add(Version version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.versions.values().containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Version> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<Version> spliterator() {
        return Collections.unmodifiableMap(this.versions).values().spliterator();
    }

    public static final class Version {
        private final String id;
        private final String type;
        private final String url;
        private final String time;
        private final String releaseTime;
        private final String detailsUrl;
        private VersionDetails details;

        Version(String id, String type, String url, String time, String releaseTime, String details) {
            this.id = id;
            this.type = type;
            this.url = url;
            this.time = time;
            this.releaseTime = releaseTime;
            this.detailsUrl = details;
        }

        public String id() {
            return this.id;
        }

        public String id(GameSide side) {
            return this.details().sharedMappings() ? this.id : this.id + "-" + side.id();
        }

        public String type() {
            return this.type;
        }

        public String url() {
            return this.url;
        }

        public String time() {
            return this.time;
        }

        public String releaseTime() {
            return this.releaseTime;
        }

        public VersionDetails details() {
            if (this.details == null) {
                this.details = VersionManifest.readDetails(this);
            }
            return this.details;
        }
    }

    public static final class VersionDetails {
        private final Version version;
        private final String normalizedVersion;
        private final List<String> manifests;
        private final boolean sharedMappings;

        VersionDetails(Version version, String normalizedVersion, List<String> manifests, boolean sharedMappings) {
            this.version = version;
            this.normalizedVersion = normalizedVersion;
            this.manifests = manifests;
            this.sharedMappings = sharedMappings;
        }

        public Version version() {
            return this.version;
        }

        public String normalizedVersion() {
            return this.normalizedVersion;
        }

        public List<String> manifests() {
            return this.manifests;
        }

        public boolean sharedMappings() {
            return this.sharedMappings;
        }
    }
}

