/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.installer.GameSide;
import org.quiltmc.installer.LoaderType;
import org.quiltmc.installer.Localization;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.action.InstallMessageType;
import org.quiltmc.installer.gui.swing.SwingInstaller;

abstract class AbstractPanel
extends JPanel {
    final SwingInstaller gui;
    @Nullable
    private VersionManifest manifest;
    @Nullable
    private Map<LoaderType, List<String>> loaderVersions;
    @Nullable
    private Map<String, String> intermediaryVersions;

    AbstractPanel(SwingInstaller gui) {
        this.gui = gui;
        this.setLayout(new BoxLayout(this, 3));
    }

    JComponent addRow() {
        JPanel rowPanel = new JPanel(new FlowLayout());
        this.add(rowPanel);
        return rowPanel;
    }

    void receiveVersions(VersionManifest manifest, Map<LoaderType, List<String>> loaderVersions, Map<String, String> intermediaryVersions) {
        this.manifest = manifest;
        this.loaderVersions = loaderVersions;
        this.intermediaryVersions = intermediaryVersions;
    }

    @Nullable
    VersionManifest manifest() {
        return this.manifest;
    }

    @Nullable
    public Map<LoaderType, List<String>> loaderVersions() {
        return this.loaderVersions;
    }

    @Nullable
    public List<String> loaderVersions(LoaderType type) {
        return this.loaderVersions == null ? null : this.loaderVersions.get((Object)type);
    }

    @Nullable
    public Map<String, String> intermediaryVersions() {
        return this.intermediaryVersions;
    }

    abstract LoaderType loaderType();

    static void populateMinecraftVersions(GameSide side, JComboBox<String> comboBox, VersionManifest manifest, Map<String, String> intermediaryVersions, boolean snapshots) {
        comboBox.removeAllItems();
        manifest.parallelStream().filter(version -> version.type().equals("release") || version.type().equals("snapshot") && snapshots || version.type().equals("old_beta") && snapshots || version.type().equals("old_alpha") && snapshots || version.type().equals("alpha_server") && snapshots || version.type().equals("classic_server") && snapshots).filter(version -> intermediaryVersions.containsKey(version.id()) || intermediaryVersions.containsKey(version.id() + "-" + side.id())).map(VersionManifest.Version::id).forEachOrdered(comboBox::addItem);
        comboBox.setEnabled(true);
    }

    static void populateLoaderVersions(GameSide side, JComboBox<String> comboBox, List<String> loaderVersions, boolean betas) {
        comboBox.removeAllItems();
        for (String loaderVersion : loaderVersions) {
            if (!betas && loaderVersion.contains("-")) continue;
            comboBox.addItem(loaderVersion);
        }
        comboBox.setEnabled(true);
    }

    @Nullable
    static String displayFileChooser(String initialDir) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(initialDir));
        chooser.setDialogTitle(Localization.get("gui.install-location.select"));
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(null) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    protected static boolean showPopup(String title, String description, int optionType, int messageType) {
        JEditorPane pane = new JEditorPane("text/html", "<html><body style=\"" + AbstractPanel.buildEditorPaneStyle() + "\">" + description + "</body></html>");
        pane.setEditable(false);
        pane.addHyperlinkListener(e -> {
            block3: {
                try {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block3;
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                        break block3;
                    }
                    throw new UnsupportedOperationException("Failed to open " + e.getURL().toString());
                }
                catch (Throwable throwable) {
                    AbstractPanel.displayError(pane, throwable);
                }
            }
        });
        return JOptionPane.showOptionDialog(null, pane, title, optionType, messageType, null, null, null) == 0;
    }

    protected static void showInstalledMessage(LoaderType type, InstallMessageType msg) {
        if (msg == InstallMessageType.SUCCEED) {
            AbstractPanel.showPopup(Localization.get("dialog.install.successful"), Localization.createFrom("dialog.install.successful.description", type.getLocalizedName(), "https://modrinth.com/mod/osl"), -1, 1);
        } else if (msg == InstallMessageType.FAIL) {
            AbstractPanel.showPopup(Localization.get("dialog.install.failed"), Localization.createFrom("dialog.install.failed.description", type.getLocalizedName()), -1, 1);
        }
    }

    private static String buildEditorPaneStyle() {
        JLabel label = new JLabel();
        Font font = label.getFont();
        Color color = label.getBackground();
        return String.format("font-family:%s;font-weight:%s;font-size:%dpt;background-color: rgb(%d,%d,%d);", font.getFamily(), font.isBold() ? "bold" : "normal", font.getSize(), color.getRed(), color.getGreen(), color.getBlue());
    }

    static void displayError(Component parent, Throwable throwable) {
        JOptionPane.showMessageDialog(parent, throwable.toString(), "Error!", 0);
        throwable.printStackTrace();
    }

    class LoaderLabel
    extends JLabel {
        public final LoaderType type;

        public LoaderLabel(LoaderType type) {
            super(type.getLocalizedName());
            this.type = type;
        }

        @Override
        public String toString() {
            return this.getText();
        }
    }
}

