/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.installer.gui.swing;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.quiltmc.installer.LoaderType;
import org.quiltmc.installer.Localization;
import org.quiltmc.installer.OrnitheMeta;
import org.quiltmc.installer.VersionManifest;
import org.quiltmc.installer.gui.swing.AbstractPanel;
import org.quiltmc.installer.gui.swing.ClientPanel;
import org.quiltmc.installer.gui.swing.ServerPanel;

public final class SwingInstaller
extends JFrame {
    private final ClientPanel clientPanel;
    private final ServerPanel serverPanel;

    public static void run() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        new SwingInstaller();
    }

    private SwingInstaller() {
        try {
            JTabbedPane contentPane = new JTabbedPane(1);
            this.clientPanel = new ClientPanel(this);
            contentPane.addTab(Localization.get("tab.client"), null, this.clientPanel, Localization.get("tab.client.tooltip"));
            this.serverPanel = new ServerPanel(this);
            contentPane.addTab(Localization.get("tab.server"), null, this.serverPanel, Localization.get("tab.server.tooltip"));
            HashSet endpoints = new HashSet();
            for (LoaderType type : LoaderType.values()) {
                endpoints.add(OrnitheMeta.loaderVersionsEndpoint(type));
            }
            endpoints.add(OrnitheMeta.INTERMEDIARY_VERSIONS_ENDPOINT);
            ((CompletableFuture)OrnitheMeta.create("https://meta.ornithemc.net", endpoints).thenAcceptBothAsync(VersionManifest.create(), (quiltMeta, manifest) -> {
                EnumMap<LoaderType, List<String>> loaderVersions = new EnumMap<LoaderType, List<String>>(LoaderType.class);
                for (LoaderType type : LoaderType.values()) {
                    loaderVersions.put(type, quiltMeta.getEndpoint(OrnitheMeta.loaderVersionsEndpoint(type)).stream().filter(v -> {
                        if (type != LoaderType.QUILT) {
                            return true;
                        }
                        return !v.startsWith("0.16.0-beta.") || v.length() != 13 || v.charAt(12) == '9';
                    }).collect(Collectors.toList()));
                }
                Map<String, String> intermediaryVersions = quiltMeta.getEndpoint(OrnitheMeta.INTERMEDIARY_VERSIONS_ENDPOINT);
                this.clientPanel.receiveVersions((VersionManifest)manifest, (Map<LoaderType, List<String>>)loaderVersions, intermediaryVersions);
                this.serverPanel.receiveVersions((VersionManifest)manifest, (Map<LoaderType, List<String>>)loaderVersions, intermediaryVersions);
            })).exceptionally(e -> {
                e.printStackTrace();
                AbstractPanel.displayError(this, e);
                return null;
            });
            this.setContentPane(contentPane);
            this.setDefaultCloseOperation(3);
            this.setTitle(Localization.get("title"));
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemClassLoader().getResource("icon.png")));
            this.pack();
            this.setLocationRelativeTo(null);
            this.setResizable(false);
            this.setVisible(true);
        }
        catch (HeadlessException e2) {
            System.exit(1);
            throw new IllegalStateException();
        }
        catch (Throwable t) {
            AbstractPanel.displayError(this, t);
            System.exit(1);
            throw new IllegalStateException();
        }
    }
}

